﻿using System;
using System.Text;
using System.Collections.Generic;
using System.Linq;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using SampleRedirector.Tests.Fakes;
using SampleRedirector.Modules;
using SampleRedirector.Configuration;
using System.Configuration;

namespace SampleRedirector.Tests
{
	/// <summary>
	/// Summary description for UnitTest1
	/// </summary>
	[TestClass]
	public class RedirectorModuleTests
	{
		public RedirectorModuleTests()
		{
			//
			// TODO: Add constructor logic here
			//
		}

		private TestContext testContextInstance;

		/// <summary>
		///Gets or sets the test context which provides
		///information about and functionality for the current test run.
		///</summary>
		public TestContext TestContext
		{
			get
			{
				return testContextInstance;
			}
			set
			{
				testContextInstance = value;
			}
		}

		#region Folder redirection
		[TestMethod]
		public void FolderRedirection_Test()
		{
			//SEE THE APP.CONFIG FILE

			FakeHttpContext context = null;
			//Configuration from Test project's App.config file
			RedirectorConfiguration config = RedirectorConfiguration.Current;
			RedirectorModule module = new RedirectorModule();

			//The folder itself
			context = new FakeHttpContext("http://contoso.com/press-releases");
			module.RedirectRequest(context, config);
			Assert.IsTrue(context.Response.Headers["Location"] == "http://contoso.com/press");

			//The child item inside the folder
			context = new FakeHttpContext("http://contoso.com/press-releases/child-detail1.aspx");
			module.RedirectRequest(context, config);
			Assert.IsTrue(context.Response.Headers["Location"] == "http://contoso.com/press/child-detail1.aspx");
		}
		#endregion

		#region Item redirection
		[TestMethod]
		public void ItemRedirection_Test()
		{
			//SEE THE APP.CONFIG FILE
			FakeHttpContext context = null;
			RedirectorConfiguration config = RedirectorConfiguration.Current;
			RedirectorModule module = new RedirectorModule();

			context = new FakeHttpContext("http://contoso.com/news-items/index.html");
			module.RedirectRequest(context, config);
			Assert.IsTrue(context.Response.Headers["Location"] == "http://contoso.com/news-items/");

			context = new FakeHttpContext("http://contoso.com/news-items/article250.html");
			module.RedirectRequest(context, config);
			Assert.IsTrue(context.Response.Headers["Location"] == "http://contoso.com/news-items/interesting-article250.aspx");
		} 
		#endregion

		#region Domain Redirection test
		[TestMethod]
		public void DomainRedirection_Test()
		{
			//SEE THE APP.CONFIG FILE
			FakeHttpContext context = null;
			RedirectorConfiguration config = RedirectorConfiguration.Current;
			RedirectorModule module = new RedirectorModule();

			//Test the www. subdomain remove
			context = new FakeHttpContext("http://www.contoso.com/testing/");
			module.RedirectRequest(context, config);
			Assert.IsTrue(context.Response.Headers["Location"] == "http://contoso.com/testing/");

			//Test that a url without the www. is not redirected
			context = new FakeHttpContext("http://contoso.com/testing/");
			module.RedirectRequest(context, config);
			Assert.IsTrue(context.Response.Headers["Location"] == null);
		} 
		#endregion
	}
}
