﻿Public Partial Class ShowListView
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        imgbNew.Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/add_icon_color.gif") & "'")
        imgbNew.Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/add_icon_mono.gif") & "'")

        ClientScript.RegisterOnSubmitStatement(Me.Page.GetType(), "ChangeColourOfInvalidControls", "ChangeColourOfInvalidControls();")
    End Sub

    Private Sub imgbNew_Click(ByVal sender As Object, ByVal e As System.Web.UI.ImageClickEventArgs) Handles imgbNew.Click
        lvContacts.InsertItemPosition = InsertItemPosition.FirstItem
        imgbNew.Enabled = False
        ' cancels if any row is in edit mode
        lvContacts.EditIndex = -1
    End Sub

    Protected Sub CancelAddNew()
        lvContacts.InsertItemPosition = InsertItemPosition.None
        imgbNew.Enabled = True
    End Sub

    Private Sub lvContacts_DataBound(ByVal sender As Object, ByVal e As System.EventArgs) Handles lvContacts.DataBound
        If Not lvContacts.InsertItem Is Nothing Then
            If lvContacts.InsertItem.FindControl("imgbInsert") IsNot Nothing Then
                TryCast(lvContacts.InsertItem.FindControl("imgbInsert"), ImageButton).Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/add_icon_color.gif") & "'")
                TryCast(lvContacts.InsertItem.FindControl("imgbInsert"), ImageButton).Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/add_icon_mono.gif") & "'")
                TryCast(lvContacts.InsertItem.FindControl("imgbCancelInsert"), ImageButton).Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/undo_icon_color.gif") & "'")
                TryCast(lvContacts.InsertItem.FindControl("imgbCancelInsert"), ImageButton).Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/undo_icon_mono.gif") & "'")
            End If
        End If
    End Sub

    Private Sub lvContacts_ItemDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ListViewItemEventArgs) Handles lvContacts.ItemDataBound
        If Not e.Item.FindControl("imgbEdit") Is Nothing Then
            TryCast(e.Item.FindControl("imgbEdit"), ImageButton).Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/edit_icon_color.gif") & "'")
            TryCast(e.Item.FindControl("imgbEdit"), ImageButton).Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/edit_icon_mono.gif") & "'")
            TryCast(e.Item.FindControl("imgbDelete"), ImageButton).Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/delete_icon_color.gif") & "'")
            TryCast(e.Item.FindControl("imgbDelete"), ImageButton).Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/delete_icon_mono.gif") & "'")
        End If

        If Not e.Item.FindControl("imgbUpdate") Is Nothing Then
            TryCast(e.Item.FindControl("imgbUpdate"), ImageButton).Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/save_icon_color.gif") & "'")
            TryCast(e.Item.FindControl("imgbUpdate"), ImageButton).Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/save_icon_mono.gif") & "'")
            TryCast(e.Item.FindControl("imgbCancel"), ImageButton).Attributes.Add("onmouseover", "this.src='" & Page.ResolveUrl("~/Images/undo_icon_color.gif") & "'")
            TryCast(e.Item.FindControl("imgbCancel"), ImageButton).Attributes.Add("onmouseout", "this.src='" & Page.ResolveUrl("~/Images/undo_icon_mono.gif") & "'")
        End If
    End Sub

    Private Sub lvContacts_ItemInserting(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ListViewInsertEventArgs) Handles lvContacts.ItemInserting
        e.Values("ContactTypeID") = TryCast(e.Item.FindControl("ddlContactTypeInsert"), DropDownList).SelectedValue
    End Sub

    Private Sub lvContacts_ItemInserted(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ListViewInsertedEventArgs) Handles lvContacts.ItemInserted
        CancelAddNew()
    End Sub

    Private Sub lvContacts_ItemEditing(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ListViewEditEventArgs) Handles lvContacts.ItemEditing
        CancelAddNew()
    End Sub
End Class