﻿<%@ Page Language="vb" AutoEventWireup="false" CodeBehind="ShowListView.aspx.vb" Inherits="ExploreListView.ShowListView" StyleSheetTheme="Nice"%>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <title>Untitled Page</title>
</head>
<body>
    
   <script language="javascript" type="text/javascript">

   function ChangeColourOfInvalidControls()
   {
        try
        {        
            for (var i = 0; i < Page_Validators.length; i++)
            {
                var valdtr = Page_Validators[i];
                var ctrl = document.getElementById(valdtr.controltovalidate);
                if (ctrl != null && ctrl.style != null)
                {
                  if (!valdtr.isvalid)
                      ctrl.style.backgroundColor="#F3F781";
                  else
                      ctrl.style.backgroundColor = "";
                }
            }
        }
        catch(e)
        {
            //Page_Validators will be null on page load
        }
    }
    </script> 
    
    <form id="form1" runat="server">
    
    <h1>Contacts List View</h1>
            
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>    
    <div>
        <asp:SqlDataSource ID="sqlDsContacts" runat="server" 
                ConnectionString="<%$ ConnectionStrings:AdventureWorksConnectionString %>" 
                SelectCommand="SELECT TOP 5 ContactID, c.ContactTypeID, pc.Name AS ContactType, Title, FirstName, LastName, Phone FROM Person.Contact c INNER JOIN Person.ContactType pc ON pc.ContactTypeID = c.ContactTypeID ORDER BY ContactID DESC"
                UpdateCommand="UPDATE Person.Contact SET ContactTypeID=@ContactTypeID, Title=@Title, FirstName=@FirstName, LastName=@LastName, Phone=@Phone WHERE ContactID=@ContactID"
                InsertCommand="INSERT INTO Person.Contact (ContactTypeID, Title, FirstName, LastName, Phone) VALUES (@ContactTypeID, @Title, @FirstName, @LastName, @Phone)"
                DeleteCommand="DELETE FROM Person.Contact WHERE ContactID=@ContactID">
            <UpdateParameters>
                <asp:Parameter Name="ContactID" Type="Int32" />
                <asp:Parameter Name="ContactTypeID" Type="Int32" />
                <asp:Parameter Name="Title" Type="String" />
                <asp:Parameter Name="FirstName" Type="String" />
                <asp:Parameter Name="LastName" Type="String" />
                <asp:Parameter Name="Phone" Type="String" />
            </UpdateParameters>
            <InsertParameters>
                <asp:Parameter Name="ContactTypeID" Type="Int32" />
                <asp:Parameter Name="Title" Type="String" />
                <asp:Parameter Name="FirstName" Type="String" />
                <asp:Parameter Name="LastName" Type="String" />
                <asp:Parameter Name="Phone" Type="String" />
            </InsertParameters>
            <DeleteParameters>
                <asp:Parameter Name="ContactID" Type="Int32" />
            </DeleteParameters>
        </asp:SqlDataSource>

        <asp:SqlDataSource ID="sqlDsContactType" runat="server" 
                ConnectionString="<%$ ConnectionStrings:AdventureWorksConnectionString %>" 
                SelectCommand="SELECT ContactTypeID, Name AS ContactType FROM Person.ContactType">
        </asp:SqlDataSource>
    </div>
    
    <asp:UpdatePanel ID="UpdatePanel2" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
        
        <asp:ValidationSummary ID="vsumSaveContact" runat="server" ValidationGroup="vgrpSaveContact" EnableClientScript="true" 
            SkinID="valSummaryError"  DisplayMode="BulletList" HeaderText="Please correct the below errors." />
                
        <table>
            <tr>
                <td>
                    <asp:ImageButton ID="imgbNew" runat="server" CausesValidation="False" CommandName="New" ImageUrl="~/Images/add_icon_mono.gif" ToolTip="Add New" width="25"></asp:ImageButton>                    
                </td>
            </tr>            
            <tr>
                <td>
                    <asp:ListView ID="lvContacts" runat="server" DataKeyNames="ContactID" 
                        DataSourceID="sqlDsContacts" InsertItemPosition="None">                
                        <LayoutTemplate>
                            <table id="tblCotnacts" runat="server" class="edit-table-listview">
                                <tr id="trHeader" runat="server">
                                    <th id="thContactType" runat="server">Contact Type</th>
                                    <th id="thTitle" runat="server">Title</th>
                                    <th id="thFirstName" runat="server">First Name</th>
                                    <th id="thLastName" runat="server">Last Name</th>
                                    <th id="thPhone" runat="server">Phone</th>
                                    <th id="thButtons" runat="server"></th>
                                </tr>
                                <tr runat="server" id="itemPlaceholder"></tr>
                              </table>
                        </LayoutTemplate>
                        
                        <ItemTemplate>
                            <tr>
                                <td width="220px">
                                    <%#Eval("ContactType")%>
                                </td>
                                <td width="55px">
                                    <%#Eval("Title")%>
                                </td>
                                <td width="85px">
                                    <%#Eval("FirstName")%>
                                </td>
                                <td width="85px">
                                    <%#Eval("LastName")%>
                                </td>
                                <td width="120px">
                                    <%#Eval("Phone")%>
                                </td>
                                <td>
                                    <asp:ImageButton ID="imgbEdit" runat="server" CommandName="Edit" Text="Edit" ImageUrl="~/Images/edit_icon_mono.gif" />
                                    <asp:ImageButton ID="imgbDelete" runat="server" CommandName="Delete" Text="Delete" ImageUrl="~/Images/delete_icon_mono.gif" OnClientClick="return confirm('Are you sure you want to delete this contact?');" ToolTip="Delete"/>
                                </td>
                            </tr>
                        </ItemTemplate>
                        
                        <InsertItemTemplate>
                            <tr>                                
                                <td>
                                    <asp:DropDownList ID="ddlContactTypeInsert" runat="server" DataSourceID="sqlDsContactType" DataTextField="ContactType" DataValueField="ContactTypeID" CssClass="edit-table-input" width="215px" AppendDataBoundItems="true">
                                        <asp:ListItem Text="" Value=""></asp:ListItem>
                                    </asp:DropDownList>
                                    <asp:RequiredFieldValidator ID="rfvSchemeSalaryTypeInsert" runat="server" ControlToValidate="ddlContactTypeInsert" ErrorMessage="Missing contact type" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtTitleInsert" runat="server" Text='<%# Bind("Title") %>' width="48px"/>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtFirstNameInsert" runat="server" Text='<%# Bind("FirstName") %>' width="78px"/>
                                    <asp:RequiredFieldValidator ID="rfvFirstNameInsert" runat="server" ControlToValidate="txtFirstNameInsert" ErrorMessage="Missing first name" SetFocusOnError="true" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtLastNameInsert" runat="server" Text='<%# Bind("LastName") %>' width="78px"/>                                    
                                    <asp:RequiredFieldValidator ID="rfvLastNameInsert" runat="server" ControlToValidate="txtLastNameInsert" ErrorMessage="Missing last name" SetFocusOnError="true" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtPhoneInsert" runat="server" Text='<%# Bind("Phone") %>' width="113px"/>
                                    <asp:RequiredFieldValidator ID="rfvPhoneInsert" runat="server" ControlToValidate="txtPhoneInsert" ErrorMessage="Missing phone number" SetFocusOnError="true" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:ImageButton ID="imgbInsert" runat="server" CommandName="Insert" Text="Insert" ImageUrl="~/Images/add_icon_mono.gif" ValidationGroup="vgrpSaveContact"/>
                                    <asp:ImageButton ID="imgbCancelInsert" runat="server" CommandName="Cancel" Text="Clear" onclick="CancelAddNew" ImageUrl="~/Images/undo_icon_mono.gif"/>
                                </td>
                            </tr>
                        </InsertItemTemplate>

                        <EditItemTemplate>
                            <tr>
                                <td>
                                    <asp:DropDownList ID="ddlContactTypeEdit" runat="server" DataSourceID="sqlDsContactType" DataTextField="ContactType" DataValueField="ContactTypeID" SelectedValue='<%# Bind("ContactTypeID") %>'  CssClass="edit-table-input" width="215px" AppendDataBoundItems="true">
                                        <asp:ListItem Text="" Value=""></asp:ListItem>
                                    </asp:DropDownList>
                                    <asp:RequiredFieldValidator ID="rfvSchemeSalaryTypeEdit" runat="server" ControlToValidate="ddlContactTypeEdit" ErrorMessage="Missing contact type" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtTitleEdit" runat="server" Text='<%# Bind("Title") %>' width="48px"/>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtFirstNameEdit" runat="server" Text='<%# Bind("FirstName") %>' width="78px"/>
                                    <asp:RequiredFieldValidator ID="rfvFirstNameEdit" runat="server" ControlToValidate="txtFirstNameEdit" ErrorMessage="Missing first name" SetFocusOnError="true" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtLastNameEdit" runat="server" Text='<%# Bind("LastName") %>' width="78px"/>
                                    <asp:RequiredFieldValidator ID="rfvLastNameEdit" runat="server" ControlToValidate="txtLastNameEdit" ErrorMessage="Missing last name" SetFocusOnError="true" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:TextBox ID="txtPhoneEdit" runat="server" Text='<%# Bind("Phone") %>' width="113px"/>
                                    <asp:RequiredFieldValidator ID="rfvPhoneEdit" runat="server" ControlToValidate="txtPhoneEdit" ErrorMessage="Missing phone" SetFocusOnError="true" ValidationGroup="vgrpSaveContact" Display="None"></asp:RequiredFieldValidator>
                                </td>
                                <td>
                                    <asp:ImageButton ID="imgbUpdate" runat="server" CommandName="Update" Text="Update" ImageUrl="~/Images/save_icon_mono.gif" CausesValidation="true" ValidationGroup="vgrpSaveContact"/>
                                    <asp:ImageButton ID="imgbCancel" runat="server" CommandName="Cancel" Text="Cancel" ImageUrl="~/Images/undo_icon_mono.gif" CausesValidation="false"/>
                                </td>
                            </tr>
                        </EditItemTemplate>
                        
                        <EmptyDataTemplate>
                            <tr>
                                <td>
                                    No data was returned.
                                </td>
                            </tr>
                        </EmptyDataTemplate>
                    </asp:ListView>
                </td>
            </tr>
        </table>            
   </ContentTemplate>
  </asp:UpdatePanel>
    </form>
</body>
</html>
