﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Cognize.GoogleSearchAPIIntegration;
using System.Text;

public partial class Controls_GoogleSearchResultsViewer : System.Web.UI.UserControl
{
    protected void Page_Init( object sender, EventArgs e )
    {
        // Clear results for fresh search
        uc_googleSearchResultPnl.Controls.Clear();

        string searchString = Request.QueryString[ "SearchString" ];

        if (!String.IsNullOrEmpty( searchString ))
        {
            string site = SiteToSearch;

            int searchResultsRequested = MaxSearchResults;

            // Default to 8 results where no
            // value specified.
            if (searchResultsRequested == 0)
            {
                searchResultsRequested = 8;
            }

            SortedList<int, Results> googleSearchResults = GoogleSearch.GetSearchResults( site, searchString, searchResultsRequested );

            if (googleSearchResults.Count > 0)
            {
                PopulateResultsPnl( googleSearchResults );
            }
            else
            {
                DisplayNoResultsMessage();
            }
        }
    }

    private void DisplayNoResultsMessage()
    {
        Literal resultsLiteral = new Literal();
        resultsLiteral.Text = "<span class=\"noResultsMessage\">Sorry, there are no results for your search.</span>";

        uc_googleSearchResultPnl.Controls.Add( resultsLiteral );
    }

    private void PopulateResultsPnl( SortedList<int, Results> googleSearchResults )
    {
        StringBuilder resultHtmlStringBuilder = new StringBuilder();

        for (int i = 0; i < googleSearchResults.Count; i++)
        {
            resultHtmlStringBuilder.Append( "<div class=\"resultItem\">" );
            resultHtmlStringBuilder.Append( "<h2>" );
            resultHtmlStringBuilder.Append( (i + 1).ToString() );
            resultHtmlStringBuilder.Append( ". <a href=\"" );
            resultHtmlStringBuilder.Append( googleSearchResults[i].url );
            resultHtmlStringBuilder.Append( "\">" );
            resultHtmlStringBuilder.Append( googleSearchResults[i].title );    
            resultHtmlStringBuilder.Append( "</a></h2>" );
            resultHtmlStringBuilder.Append( "<p><a href=\"" );
            resultHtmlStringBuilder.Append( googleSearchResults[i].url );
            resultHtmlStringBuilder.Append( "\">" );
            resultHtmlStringBuilder.Append( googleSearchResults[i].content );
            resultHtmlStringBuilder.Append( "</a><br />" );
            resultHtmlStringBuilder.Append( "<em><a href=\"" );
            resultHtmlStringBuilder.Append( googleSearchResults[i].url );
            resultHtmlStringBuilder.Append( "\">" );
            resultHtmlStringBuilder.Append( googleSearchResults[i].url );
            resultHtmlStringBuilder.Append( "</a></em></p>" );
            resultHtmlStringBuilder.Append( "</div>" );
        }

        Literal resultsLiteral = new Literal();
        resultsLiteral.Text = resultHtmlStringBuilder.ToString();

        uc_googleSearchResultPnl.Controls.Add( resultsLiteral );
    }

    /// <summary>
    /// The fully qualified domain of the site for which search should be restricted (optional).
    /// </summary>
    public string SiteToSearch
    {
        get;
        set;
    }

    /// <summary>
    /// The maximum number of results required.
    /// </summary>
    public int MaxSearchResults
    {
        get;
        set;
    }
}
