﻿<%@ Page Language="C#" AutoEventWireup="true" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
    <style type="text/css">
        div.wikidoc pre
        {
            background-color: #ECECEC;
            border: dashed .1em #3E62A6;
            font-family: Consolas, "Courier New" ,Courier,Monospace;
            font-size: 1em;
            margin-top: 0;
            padding: .5em;
            padding-bottom: 1.5em;
            height: auto;
            overflow: auto;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <div class="wikidoc">
            As a web developer I have often had to work with the session, cookie, query string&nbsp;and
            cache to persist data locally.&nbsp;But it has always&nbsp;struck me that there
            was no neat way of doing so. So I came up with this wrapper which is meant to&nbsp;provide&nbsp;a&nbsp;much
            simpler and unified&nbsp;model to work with. It&nbsp;is&nbsp;type safe and supports
            complex data types&nbsp;even when working with&nbsp;cookies and query strings, thanks
            to&nbsp;Json serialization which by the way&nbsp;has full&nbsp;support&nbsp;within&nbsp;javascript.
            Also a variable can seamlessly be based on more than one&nbsp;persistence type if
            need be.
            <br />
            <br />
            Below is a sample code that creates an object to store and integer in a session
            under the key &quot;counter&quot;:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> count = <span style="color: blue">new</span> Local.Integer(<span
                    style="color: #a31515">&quot;counter&quot;</span>);
</pre>
            </div>
            The Value property is used as follows to manipulate the integer:<br />
            <div style="background-color: white; color: black">
                <pre>  count.Value = count.Value + 10;
</pre>
            </div>
            Now to store the integer in a cookie the Sources.Cookie argument can be used as
            follows:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> count = <span style="color: blue">new</span> Local.Integer(<span
                    style="color: #a31515">&quot;counter&quot;</span>, Sources.Cookie);
</pre>
            </div>
            And this is how the Sources enum is declared whereby Sources.Session is the default
            when not specified:<br />
            <div style="background-color: white; color: black">
                <pre><span style="color: blue">public</span> <span style="color: blue">enum</span> Sources
{
    None = 0,
    Session = 1,
    Cookie = 2,
    Query = 4,
    Cache = 8,
    SharedCache = 16
}
</pre>
            </div>
            The key &quot;counter&quot; can be hardcoded in a custom class Keys to avoid typo
            errors:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> count = <span style="color: blue">new</span> Local.Integer(Keys.Counter, Sources.Cookie);
</pre>
            </div>
            This is a generic version of the above example:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> count = <span style="color: blue">new</span> Local.Var&lt;<span
                    style="color: blue">int</span>&gt;(Keys.Counter, Sources.Cookie);
</pre>
            </div>
            Complex types are also supported as shown here using a custom class Person:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> person1 = <span style="color: blue">new</span> Local.Var&lt;Person&gt;(<span
                    style="color: #a31515">&quot;person_1&quot;</span>);
</pre>
            </div>
            More than one source type can also be specified sequencially as follows in case
            the former type returns a null value:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> person1 = <span style="color: blue">new</span> Local.Var&lt;Person&gt;(<span
                    style="color: #a31515">&quot;person_1&quot;</span>, Sources.Session, Sources.Cookie, Sources.Cache);
</pre>
            </div>
            In the above example the object will first look for the specified key in the session.
            If this attempt fails then the request will turn to the next sources cookie and
            cache in the queue.<br />
            <br />
            By default our object value is saved to all the targets in the source list(ie session,
            cookie and cache in our case). You can avoid writing to the cache, for example,
            by limiting the target types to the session and cookie as follows:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> person1 = <span style="color: blue">new</span> Local.Var&lt;Person&gt;(<span
                    style="color: #a31515">&quot;person_1&quot;</span>, Targets.Session + Targets.Cookie, Sources.Session, Sources.Cookie, Sources.Cache);
</pre>
            </div>
            Note that saving complex objects to the cookie and query string is achieved by using
            Json serialization under the hood.<br />
            <br />
            Now there is yet another way to access keys, more especially those having a common
            prefix. Here is how:<br />
            <div style="background-color: white; color: black">
                <pre>  <span style="color: blue">var</span> persons = <span style="color: blue">new</span> Local.Var&lt;Person&gt;(<span
                    style="color: #a31515">&quot;person&quot;</span>);
  <span style="color: blue">var</span> person1 = persons[1];
  <span style="color: blue">var</span> person2 = persons[2];
</pre>
            </div>
            This will automatically map requests for person1 and person2 to the keys &quot;person_1&quot;
            and &quot;person_2&quot; respectively.<br />
            Note that &quot;_&quot; is the default delimiter used to seperate the parent and
            the child key. It is also the default key delimiter used with cookies since they
            inherently support parent/child keys.<br />
            <br />
            This sort of operation is also supported:<br />
            <div style="background-color: white; color: black">
                <pre>  persons[<span style="color: #a31515">&quot;1&quot;</span>] = persons[<span
                    style="color: #a31515">&quot;2&quot;</span>];
</pre>
            </div>
            Note that you can call the ToString() function on any object having a complex generic
            type to obtain its Json representation.<br />
            <br />
            This wrapper brings a lot of flexibility but you should avoid saving more data to
            cookies and query strings than they can handle. A cookie will automatically clear
            itself when it grows beyond its size limit. To help overcome those issues an error
            will be thrown whenever the query string size grows beyond its 2048kb size limit
            and cookie compression has now been implemented.
            <br />
            <br />
            More information on this project will be added with time if it gets enough traction
            from the community and meanwhile, of course, your suggestions, questions and critics
            are most welcome.</div>
    </div>
    </form>
</body>
</html>
