﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

public partial class Example4 : System.Web.UI.Page
{
    Local.Integer SessionCounter = new Local.Integer("SessionCounter");
    Local.Integer CacheCounter = new Local.Integer("CacheCounter");

    protected void Page_Load(object sender, EventArgs e)
    {
        AsyncTask task1 = new AsyncTask(Test1);
        PageAsyncTask pageTask1 = new PageAsyncTask(task1.OnBegin, task1.OnEnd, null, null);
        Page.RegisterAsyncTask(pageTask1);
    }

    private class AsyncTask
    {
        public delegate void AsyncTaskDelegate();
        private AsyncTaskDelegate _delegate;
        public AsyncTask(AsyncTaskDelegate task)
        {
            _delegate = task;
        }
        public IAsyncResult OnBegin(object sender, EventArgs e, AsyncCallback cb, object extraData)
        {
            return _delegate.BeginInvoke(cb, extraData);
        }
        public void OnEnd(IAsyncResult ar)
        {
            _delegate.EndInvoke(ar);
        }
    }

    private void Test1()
    {
        // To work asynchronously with the session or the cache local objects need to be given a reference to the page using it.
        SessionCounter.AsyncPageRef = CacheCounter.AsyncPageRef = Page;
        SessionCounter.Value++;
        CacheCounter.Value++;
        Response.Write("This page demonstrates the ability to work with the session and the cache from within an asynchronous method.<br/>");
        Response.Write("For this to work the AsyncPageRef property of each object needs a reference to the actual page before any asynchronous method is called or within the method itself.<br/>");
        Response.Write("Session Counter = " + SessionCounter.Value + "<br/>");
        Response.Write("Cache Counter = " + CacheCounter.Value);
    }
}
