﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Caching;

public partial class Example2 : System.Web.UI.Page
{
    Local.Var<List<Person>> Persons = new Local.Var<List<Person>>(Keys.Persons, Sources.None);
    // Variables that keep the state of the page controls in a cookie so that they can be restored anytime.
    Local.Var<Person> NewPersonState = new Local.Var<Person>(new Person(), "PersonState", Sources.Cookie);

    protected void Page_Load(object sender, EventArgs e)
    {
        // Persisting control states demonstrated using UIPersistence.
        Local.PersistentProperty<string>.Persist("Text", Sources.Cookie, IsPostBack,
            txtAge, txtCacheLifeTime, txtChildName, txtCookieLifeTime, txtHobbies, txtServerCookieLifeTime);

        Local.PersistentProperty<bool>.Persist("Checked", Sources.Cookie, IsPostBack,
            chkCompressCookie, chkCompressQuery, chkEncryptCookie, chkEncryptServerCookie, chkEncryptQuery);

        Local.PersistentProperty<string>.Persist("SelectedValue", Sources.Cookie, IsPostBack,
            ddlSourceTypes1, ddlSourceTypes2);

        if (IsPostBack)
        {
            // Store control states using the cookie. 
            NewPersonState.Value = new Person()
            {
                Name = txtChildName.Text,
                Age = int.Parse("0" + txtAge.Text),
                Hobbies = txtHobbies.Text
            };
        }
        else
        {
            // Restore NewPersonState from the cookie.
            Person personState = NewPersonState.Value;
        }

        // Instanciates an object to store a list of objects of type Person in the query string
        // Note that the target type list is always equal to the source type list when not specified
        // in the constructor.
        Persons.SourceTypes = new Sources[] 
        { 
            (Sources)Enum.Parse(typeof(Sources), ddlSourceTypes1.SelectedValue), 
            (Sources)Enum.Parse(typeof(Sources), ddlSourceTypes2.SelectedValue)
        };

        // Set cookie lifetime if specified
        if (txtCookieLifeTime.Text.Length > 0)
            Persons.CookieLifeTime = TimeSpan.FromSeconds(double.Parse(txtCookieLifeTime.Text));

        // Set cookie lifetime if specified
        if (txtServerCookieLifeTime.Text.Length > 0)
            Persons.ServerCookieLifeTime = TimeSpan.FromSeconds(double.Parse(txtServerCookieLifeTime.Text));

        // Set cache lifetime if specified
        if (txtCacheLifeTime.Text.Length > 0)
            Persons.CacheLifeTime = TimeSpan.FromSeconds(double.Parse(txtCacheLifeTime.Text));
        // Call the CacheItemRemovedCallback method when the cache is destroyed
        // Note that the Local object cannot be used in this method since the page http context is null
        // at the moment it is called.
        Persons.CacheItemRemovedCallback += new CacheItemRemovedCallback(CacheItemRemoved);

        // Enable compression
        Persons.CompressCookie = chkCompressCookie.Checked;
        Persons.CompressQueryString = chkCompressQuery.Checked;
        // Enable encryption
        Persons.EncryptCookie = chkEncryptCookie.Checked;
        Persons.EncryptServerCookie = chkEncryptServerCookie.Checked;
        Persons.EncryptQueryString = chkEncryptQuery.Checked;
        // Allow sharing amongst users
        Persons.ShareCache = chkShareCache.Checked;
        Persons.ShareServerCookie = chkShareServerCookie.Checked;

        chkCompressCookie.Visible = Persons.SourceIs(Sources.Cookie);
        tdCookieLifeTime.Visible = Persons.SourceIs(Sources.Cookie);
        chkEncryptCookie.Visible = Persons.SourceIs(Sources.Cookie);
        chkCompressQuery.Visible = Persons.SourceIs(Sources.QueryString);
        chkEncryptQuery.Visible = Persons.SourceIs(Sources.QueryString);
        tdCacheLifeTime.Visible = Persons.SourceIs(Sources.Cache);
        tdServerCookieLifeTime.Visible = Persons.SourceIs(Sources.ServerCookie);
        chkEncryptServerCookie.Visible = Persons.SourceIs(Sources.ServerCookie);
        chkShareServerCookie.Visible = Persons.SourceIs(Sources.ServerCookie);

        DisplayResults();
    }

    private void CacheItemRemoved(string key, object value, CacheItemRemovedReason reason)
    {
    }

    private void DisplayResults()
    {
        txtResult.Text = "";

        if (Persons.Value != null)
        {
            // The father is identified by his number of sibblings
            Person father = Persons.Value.Where(p => p.Siblings.Count > 0).FirstOrDefault();
            if (father != null)
            {
                txtResult.Text += string.Format("{0} has {1} sibblings named ", father.Name, father.Siblings.Count);

                for (int i = 0; i < father.Siblings.Count; i++)
                    txtResult.Text += (i == 0 ? "" : i == father.Siblings.Count - 1 ? " and " : ", ")
                        + father.Siblings[i].Name;

                txtResult.Text += (".\nJson data for the list of persons:\n" + Persons ?? "");
            }
            lblNoValueMsg.Text = "";
        }
        else
        {
            if (Persons.KeyExists)
                lblNoValueMsg.Text = "The value stored is either compressed or encrypted incorrectly. "
                    + "Please check the formats above or click on the button below to create a new entry.";
            else
                lblNoValueMsg.Text = "No entry was found in the above storage types. "
                    + "Please click on the button below to create one.";
        }

        if (chkEncryptServerCookie.Visible)
            chkEncryptServerCookie.Text = ("Encrypt Server Cookie(Size: "
                + Local.GetServerCookieSize() + "B)").Replace(" ", "&nbsp;");

        if (chkEncryptQuery.Visible)
            chkEncryptQuery.Text = ("Encrypt Query String (Size: "
                + Local.GetQueryStringSize() + "B)").Replace(" ", "&nbsp;"); 
    }

    protected void btnGeneratePersonsList_Click(object sender, EventArgs e)
    {
        var listOfPersons = GetPersonListSample();
        // Assigning a complex value to our object.
        // Note that if the target list includes the query string the page will be automatically
        // redirected to itself right after assigning it a value so that the query string can be updated.
        // As a result of this DisplayResults() will not be called!!
        Persons.Value = listOfPersons;
        DisplayResults();
    }

    private static List<Person> GetPersonListSample()
    {
        Person ryan = new Person() { Name = "Ryan", Age = 12, Gender = Gender.Male, Hobbies = "Football" };
        Person nancy = new Person() { Name = "Nancy", Age = 9, Gender = Gender.Female, Hobbies = "Reading and swimming" };
        Person paul = new Person() { Name = "Paul", Age = 40, Gender = Gender.Male, Hobbies = "Watching TV and browsing" };
        paul.Siblings.Add(ryan);
        paul.Siblings.Add(nancy);
        Person john = new Person() { Name = "Mary", Age = 25, Gender = Gender.Male, Hobbies = "Enjoying fresh air exercise" };
        Person mary = new Person() { Name = "John", Age = 30, Gender = Gender.Female, Hobbies = "Bungie jumping{{☻}}" };

        var listOfPersons = new List<Person>() { paul, john, mary };
        return listOfPersons;
    }

    protected void btnAddChild_Click(object sender, EventArgs e)
    {
        Persons.Disconnect();
        if (Persons.Value != null)
        {
            Person father = Persons.Value.Where(p => p.Name == "Paul").FirstOrDefault();
            if (father != null)
                father.Siblings.Add(NewPersonState.Value);
            DisplayResults();
        }

        try
        {
            Persons.SaveChanges(true);
        }
        catch (Exception ex)
        {
            Response.Write(ex.Message);
        }
    }

    protected void btnRemoveChild_Click(object sender, EventArgs e)
    {
        Persons.Disconnect();
        if (Persons.Value != null)
        {
            Person father = Persons.Value.Where(c => c.Name == "Paul").FirstOrDefault();
            if (father != null)
            {
                Person child = father.Siblings.Where(c => c.Name == txtChildName.Text).FirstOrDefault();
                if (child != null)
                    father.Siblings.Remove(child);
            }
            DisplayResults();
        }
        Persons.SaveChanges(true);
    }

    protected void btnClearAll_Click(object sender, EventArgs e)
    {
        Persons.ClearSources();
        Local.RefreshPage();
    }

    // Only used for testing cookie compression
    private void TestCookieCompression()
    {
        string s = Local.Serialization.ToJsonString<List<Person>>(GetPersonListSample());
        s = s + s + s;
        Response.Write("<br/> - " + s);
        s = Local.CookieEncryption.Encrypt(s);
        Response.Write("<br/> - " + s);
        s = HttpUtility.HtmlAttributeEncode(s);
        Response.Write("<br/> - " + s);
        Local.SetCookie("CompressCookie", s, true, true);
        s = Local.GetCookie("CompressCookie", true, true);
        Response.Write("<br/> - " + s);
        s = Local.CookieEncryption.Decrypt(s, true);
        Response.Write("<br/> - " + s);
        Response.Write("<br/>");
    }
}