﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Specialized;


public partial class Default2 : System.Web.UI.Page
{
    // Instantiate an object stored in the query string with a value of type boolean.
    // Its default value is set to true.
    Local.QueryString<bool> ShowCounters = new Local.QueryString<bool>(Keys.ShowCounters) { DefaultValue = true };

    //int testInt = new Local.Integer("testInt", Sources.Cookie).Value;

    // This string variable is stored under the key "MyTestKey" and is accessible through the Value property.
    // "not specified" is the value returned when the key is neither in the query nor the cookie.
    // Its cookie lifetime is 15 seconds. It defaults to 100 days when left null.
    // Its cache lifetime is set to the default value of 20 minutes(but it is not used here since it is not listed).
    // During set operations the value is saved to the cookie and session only.
    // During get operations the value is retrieved from the query string or otherwise the cookie if the query is absent.
    Local.String MyTestString = new Local.String("not specified", Keys.MyTestKey, TimeSpan.FromSeconds(15), null,
       Targets.Cookie + Targets.Session, Sources.QueryString, Sources.Cookie);

    protected void Page_Load(object sender, EventArgs e)
    {
        Response.Write("Below are the results for the object MyTestString having for sources the query string and the cookie(timeout is 15s) " +
            "and for targets the cookie and the session.<br/><br/>");
        Response.Write("The query value is <b>" + (Local.GetQueryString(Keys.MyTestKey) ?? "null") + "</b><br/>");
        Response.Write("The cookie value is <b>" + (Local.GetCookie(Keys.MyTestKey) ?? "null") + "</b><br/>");
        Response.Write("The session value is <b>" + (Local.GetSession(Keys.MyTestKey) ?? "null") + "</b><br/>");

        Response.Write("<br/>The value of our test object is now <b>" + MyTestString + "</b><br/><br/>");

        bool cookieIsNull = Local.GetCookie(Keys.MyTestKey) == null;
        bool queryIsNull = Local.GetQueryString(Keys.MyTestKey) == null;
        bool sessionIsNull = Local.GetSession(Keys.MyTestKey) == null;

        btnCopySourceToAllTargets.Enabled = MyTestString.KeyExists;
        btnRemoveMyTestKey.Enabled = !queryIsNull;
        btnAddQueryKey.Enabled = queryIsNull;

        if (!MyTestString.KeyExists)
        {
            Response.Write("Our object has no value since none of its sources contains the test key yet.<br/>" +
                "Click on 'Add Test Key' to add the required key to the query string.<br/>");
        }
        else
        {
            if (cookieIsNull)
            {
                if (sessionIsNull)
                {
                    Response.Write("<br/>Our object now has found the test key in the query string.<br/>" +
                        "The cookie contains no value because the Value property of our object has not yet been assigned a value.<br/>");
                }
                else
                {
                    Response.Write("The cookie has now expired.<br/>");
                }
                Response.Write("You can assign it a value by clicking on the 'Set A Random Value' " +
                    "or the 'Call CopySourceToAllTargets' button.<br/>");
            }

            if (queryIsNull)
            {
                Response.Write("The test key is non existent in the query string but our object still returns a value " +
                    "since it is now using the cookie as source.<br/>");
            }
            else
            {
                Response.Write("You can clear the test key from query string by clicking on the 'Remove Test Key' button.<br/>");
            }

            if (!sessionIsNull && !cookieIsNull)
            {
                Response.Write("Both targets, the cookie and the session, have been updated. The cookie will expire in 15s.<br/>" +
                    "This can be verified by using the 'Refresh' button after this period.<br/>");
            }
        }

        if (ShowCounters.Value)
        {
            btnCounters.Text = "Hide counters";

            // Instanciating three objects with integer typed values using session, cookie and cache as storage sources respectively
            var sessionCounter = new Local.Integer(Keys.Counter);// The source type defaults to the session when none is specified.
            var cookieCounter = new Local.Integer(Keys.Counter, Sources.Cookie);// This integer will be stored as a cookie
            var cacheCounter = new Local.Integer(Keys.Counter, Sources.Cache);// This one will be stored in the cache

            // Increment each integer at every request
            sessionCounter.Value++;
            cookieCounter.Value++;
            cacheCounter.Value++;

            Response.Write("<br/>");
            // Display their values
            Response.Write("Cookie Counter = " + cookieCounter + "<br/>");
            Response.Write("Session Counter = " + sessionCounter + "<br/>");
            Response.Write("Cache Counter = " + cacheCounter + "<br/>");
        }
        else
        {
            btnCounters.Text = "Show counters";
        }
    }


    protected void btnRefresh_Click(object sender, EventArgs e)
    {

    }

    protected void btnShowHideCounters_Click(object sender, EventArgs e)
    {
        ShowCounters.Value = !ShowCounters.Value;
    }

    protected void btnAddQueryKey_Click(object sender, EventArgs e)
    {
        Local.SetQueryString(Keys.MyTestKey, "Test Value");
    }

    protected void btnSetRandomValue_Click(object sender, EventArgs e)
    {
        MyTestString.Value = new Random().Next(10000).ToString();
        // Whenever Sources.Query is included in the target list the page is always refreshed 
        // upon value assignment. This is achieved through the Response.Redirect method.
        // This line of code will therefore not be reached in this case.
        Local.RefreshPage();
    }

    protected void btnCopySourceToAllTargets_Click(object sender, EventArgs e)
    {
        MyTestString.CopySourceToAllTargets();
        Local.RefreshPage();
    }

    protected void btnRemoveMyTestKey_Click(object sender, EventArgs e)
    {
        Local.SetQueryString(Keys.MyTestKey, null);
    }

}
