using System;
using System.Web;
using System.Web.Security;
using System.Reflection;

namespace System.Web
{
    public partial class LocalBase
    {
        /// <summary>
        /// A wrapper around System.Web.Security.CookieProtectionHelper internal class
        /// </summary>
        public static class CookieProtectionHelperWrapper
        {
            private static MethodInfo _methodEncode;
            private static MethodInfo _methodDecode;
            private const string INTERNAL_CLASS_NAME = "System.Web.Security.CookieProtectionHelper";

            static CookieProtectionHelperWrapper()
            {
                // Get a reference to System.Web assembly
                Assembly systemWeb = typeof(HttpContext).Assembly;
                if (systemWeb == null)
                    throw new InvalidOperationException("Unable to load System.Web.");

                // Get a reference to the internal class CookieProtectionHelper
                Type cookieProtectionHelper = systemWeb.GetType(INTERNAL_CLASS_NAME);

                if (cookieProtectionHelper == null)
                    throw new InvalidOperationException("Unable to get the internal class " + INTERNAL_CLASS_NAME);

                // Get references to the methods of CookieProtectionHelper class
                _methodEncode = cookieProtectionHelper.GetMethod("Encode", BindingFlags.NonPublic | BindingFlags.Static);
                _methodDecode = cookieProtectionHelper.GetMethod("Decode", BindingFlags.NonPublic | BindingFlags.Static);

                if (_methodEncode == null || _methodDecode == null)
                    throw new InvalidOperationException("Unable to get references to the encode/decode methods.");
            }

            public static string Encode(CookieProtection cookieProtection, byte[] buf, int count)
            {
                return (string)_methodEncode.Invoke(null, new object[] { cookieProtection, buf, count });
            }

            public static byte[] Decode(CookieProtection cookieProtection, string data)
            {
                return (byte[])_methodDecode.Invoke(null, new object[] { cookieProtection, data });
            }

        }

    }
}