using System;
using System.Web;
using System.Text;
using System.Web.Security;

namespace System.Web
{
    public partial class LocalBase
    {
        /// <summary>
        /// A class to encode, decode and validate strings based on the MachineKey
        /// </summary>
        public static class CookieEncryption
        {
            public static string Encrypt(string text)
            {
                return Encrypt(text, CookieProtection.All);
            }

            public static string Encrypt(string text, CookieProtection cookieProtection)
            {
                byte[] buf = Encoding.UTF8.GetBytes(text);
                return CookieProtectionHelperWrapper.Encode(cookieProtection, buf, buf.Length);
            }

            /// <summary>
            /// Decodes a cookie that has all levels of cookie protection.
            /// </summary>
            public static string Decrypt(string text, bool returnNullOnError)
            {
                return Decrypt(text, CookieProtection.All, returnNullOnError);
            }

            /// <summary>
            /// Decodes a string
            /// </summary>
            /// <param name="text">String to decode</param>
            /// <param name="cookieProtection">The method in which the string is protected</param>
            /// <returns>The decoded string or throws InvalidCastException tampered with</returns>
            public static string Decrypt(string text, CookieProtection cookieProtection, bool returnNullOnError)
            {
                if (string.IsNullOrEmpty(text))
                    return text;

                byte[] buf;
                try
                {
                    buf = CookieProtectionHelperWrapper.Decode(cookieProtection, text);
                    if (buf == null || buf.Length == 0)
                        throw new Exception();

                }
                catch (Exception ex)
                {
                    if (returnNullOnError)
                        return null;
                    else
                        throw new InvalidCastException("Unable to decode the text", ex.InnerException);
                }

                return Encoding.UTF8.GetString(buf, 0, buf.Length);
            }
        }
    }
}