﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace System.Web
{
    public partial class Local : LocalBase
    {
        public class Session : Var<string>
        {
            public Session(string key)
                : base(null, key, null, null, null, null, Sources.Session) { }
        }

        public class Session<T> : Var<T>
        {
            public Session(string key)
                : base(default(T), key, null, null, null, null, Sources.Session) { }
        }

        public class Cookie : Var<string>
        {
            public Cookie(string key)
                : base(null, key, null, null, null, null, Sources.Cookie) { }

            public Cookie(string key, TimeSpan lifeTime)
                : base(null, key, lifeTime, null, null, null, Sources.Cookie) { }

            public Cookie(string key, TimeSpan lifeTime, bool compress, bool encrypt)
                : base(null, key, lifeTime, null, null, null, Sources.Cookie)
            {
                CompressCookie = compress;
                EncryptCookie = compress;
            }
        }

        public class Cookie<T> : Var<T>
        {
            public Cookie(string key)
                : base(default(T), key, null, null, null, null, Sources.Cookie) { }

            public Cookie(string key, TimeSpan lifeTime)
                : base(default(T), key, lifeTime, null, null, null, Sources.Cookie) { }
          
            public Cookie(string key, TimeSpan lifeTime, bool compress, bool encrypt)
                : base(default(T), key, lifeTime, null, null, null, Sources.Cookie)
            {
                CompressCookie = compress;
                EncryptCookie = compress;
            }
        }

        public class QueryString : Var<string>
        {
            public QueryString(string key)
                : base(null, key, null, null, null, null, Sources.QueryString) { }

            public QueryString(string key, bool compress, bool encrypt)
                : base(null, key, null, null, null, null, Sources.QueryString)
            {
                CompressQueryString = compress;
                EncryptQueryString = encrypt;
            }
        }

        public class QueryString<T> : Var<T>
        {
            public QueryString(string key)
                : base(default(T), key, null, null, null, null, Sources.QueryString) { }

            public QueryString(string key, bool compress, bool encrypt)
                : base(default(T), key, null, null, null, null, Sources.QueryString)
            {
                CompressQueryString = compress;
                EncryptQueryString = encrypt;
            }
        }

        public class Cache : Var<string>
        {
            public Cache(string key)
                : base(null, key, null, null, null, null, Sources.Cache) { }

            public Cache(string key, TimeSpan lifeTime)
                : base(null, key, null, null, lifeTime, null, Sources.Cache) { }
        }

        public class Cache<T> : Var<T>
        {
            public Cache(string key)
                : base(default(T), key, null, null, null, null, Sources.Cache) { }

            public Cache(string key, TimeSpan lifeTime)
                : base(default(T), key, null, null, lifeTime, null, Sources.Cache) { }
        }


        public class ServerCookie : Var<string>
        {
            public ServerCookie(string key)
                : base(null, key, null, null, null, null, Sources.ServerCookie) { }

            public ServerCookie(string key, TimeSpan lifeTime)
                : base(null, key, lifeTime, null, null, null, Sources.ServerCookie) { }

            public ServerCookie(string key, TimeSpan lifeTime, bool encrypt)
                : base(null, key, lifeTime, null, null, null, Sources.ServerCookie)
            {
                EncryptServerCookie = encrypt;
            }
        }

        public class ServerCookie<T> : Var<T>
        {
            public ServerCookie(string key)
                : base(default(T), key, null, null, null, null, Sources.ServerCookie) { }

            public ServerCookie(string key, TimeSpan lifeTime)
                : base(default(T), key, lifeTime, null, null, null, Sources.ServerCookie) { }

            public ServerCookie(string key, TimeSpan lifeTime, bool encrypt)
                : base(default(T), key, lifeTime, null, null, null, Sources.ServerCookie)
            {
                EncryptServerCookie = encrypt;
            }
        }
    }
}