﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.IO;

namespace System.Web
{
    public partial class Local : LocalBase
    {
        public class PersistentProperty<T> : Local.Var<T>
        {
            private string _parentKey;
            private string _propertyName;
            private object[] _controlsToPersist;
            //public string DefaultParentKey = "PersistentProperty";

            public PersistentProperty(params object[] controlsToPersist)
                : this("Text", null, Sources.Session, controlsToPersist)
            { }
            public PersistentProperty(Sources sourceType, params object[] controlsToPersist)
                : this("Text", null, sourceType, controlsToPersist)
            { }

            public PersistentProperty(string propertyName, params object[] controlsToPersist)
                : this(propertyName, null, Sources.Session, controlsToPersist)
            { }

            public PersistentProperty(string propertyName, Sources sourceType, params object[] controlsToPersist)
                : this(propertyName, null, sourceType, controlsToPersist)
            { }

            public PersistentProperty(string propertyName, string parentKey, Sources sourceType, params object[] controlsToPersist)
                : base(default(T), parentKey, null, null, null, null, sourceType)
            {
                _parentKey = parentKey != null ? parentKey
                    : HttpContext.Current.Request.AppRelativeCurrentExecutionFilePath.Substring(2).Replace('/', Local.KeyDelimiter);
                _propertyName = propertyName;
                _controlsToPersist = controlsToPersist;
            }

            public static void Persist(string propertyName, string parentKey, Sources sourceType, bool isPostBack, params object[] controlsToPersist)
            {
                new PersistentProperty<T>(propertyName, parentKey, sourceType, controlsToPersist).Persist(isPostBack);
            }

            public static void Persist(string propertyName, Sources sourceType, bool isPostBack, params object[] controlsToPersist)
            {
                new PersistentProperty<T>(propertyName, null, sourceType, controlsToPersist).Persist(isPostBack);
            }

            public static void PersistToAllUsers(string propertyName, string parentKey, bool isPostBack, params object[] controlsToPersist)
            {
                new PersistentProperty<T>(propertyName, parentKey, Sources.ServerCookie, controlsToPersist) { ShareServerCookie = true }.Persist(isPostBack);
            }

            public void Persist(bool isPostBack)
            {
                string key;
                foreach (Control control in _controlsToPersist)
                {
                    key = _parentKey + Local.KeyDelimiter + control.ID;
                    if (isPostBack)
                    {
                        T value = Reflection.GetPropertyValue<T>(control, _propertyName);
                        SetValue(key, value);
                    }
                    else
                    {
                        T value = GetValue(key, _sourceTypes);
                        if (value != null)
                            Reflection.SetPropertyValue<T>(control, _propertyName, value, true);
                    }
                }
            }

            public static void PersistThruKey(string propertyName, string key, bool isPostBack, Sources sourceType, Control controlToPersist)
            {
                PersistThruKey(default(T), propertyName, key, isPostBack, sourceType, controlToPersist);
            }
            public static void PersistThruKey(T defaultValue, string propertyName, string key, bool isPostBack, Sources sourceType, Control controlToPersist)
            {
                Local.Var<T> obj = new Local.Var<T>(defaultValue, key, sourceType);
                if (isPostBack)
                {
                    T value = Reflection.GetPropertyValue<T>(controlToPersist, propertyName);
                    obj.Value = value;
                }
                else
                {
                    T value = obj.Value;
                    if (value != null)
                        Reflection.SetPropertyValue<T>(controlToPersist, propertyName, value, true);
                }
            }
        }
    }
}
