﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.IO;
using System.Xml;
using System.Runtime.Serialization;

namespace System.Web
{
    public partial class Local : LocalBase
    {
        /// <summary>
        /// Provides a class to persist an object. However server controls are not supported since
        /// they are not serializable by the DataContractSerializer.
        /// </summary>
        /// <typeparam name="T">The object type.</typeparam>
        public class PersistentObject<T> : Local.Var<T>
        {
            private string _parentKey;
            private T _object;
            public string DefaultParentKey = "PersistentObject";

            public PersistentObject(string key, ref T objectToPersist)
                : this(null, key, Sources.Session, ref objectToPersist)
            { }
            public PersistentObject(string key, Sources sourceType, ref T objectToPersist)
                : this(null, key, sourceType, ref objectToPersist)
            { }

            public PersistentObject(string parentKey, string key, Sources sourceType, ref T objectToPersist)
                : base(default(T), key, null, null, null, null, sourceType)
            {
                _parentKey = parentKey == null ? DefaultParentKey : parentKey;
                _object = objectToPersist;
            }

            public static void Persist(string parentKey, string key, Sources sourceType, bool save, ref T objectToPersist)
            {
                new PersistentObject<T>(parentKey, key, sourceType, ref objectToPersist).Persist(save);
            }

            public static void Persist(string key, Sources sourceType, bool save, ref T objectToPersist)
            {
                new PersistentObject<T>(null, key, sourceType, ref objectToPersist).Persist(save);
            }

            public void Persist(bool save)
            {
                if (save)
                    SetValue(_parentKey + Local.KeyDelimiter + Key, _object);
                else
                    _object = GetValue(_parentKey + Local.KeyDelimiter + Key, _sourceTypes);
            }
        }
    }
}
