﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Web.Caching;

namespace System.Web
{
    public partial class Local: LocalBase
    {
        /// <summary>
        /// A class that represents a nullable version of the Var<T> class.
        /// It adds the NullableValue property which is a nullable version of the Value property itself.
        /// Note that it works for non nullable types only.
        /// </summary>
        /// <typeparam key="T">The generic type T for the variable. 
        /// Note that it must be a non nullable type</typeparam>
        public class NullableVar<T> : Var<T> where T : struct
        {
            public NullableVar(string key, params Sources[] sourceTypes)
                : base(default(T), key, null, null, null, null, sourceTypes) { }
            public NullableVar(string key, int? targetTypes, params Sources[] sourceTypes)
                : base(default(T), key, null, null, null, targetTypes, sourceTypes) { }
            public NullableVar(T defaultValue, string key, params Sources[] sourceTypes)
                : base(defaultValue, key, null, null, null, null, sourceTypes) { }
            public NullableVar(T defaultValue, string key, int? targetTypes, params Sources[] sourceTypes)
                : base(defaultValue, key, null, null, null, targetTypes, sourceTypes) { }

            /// <summary>
            /// Initializes a new instance of the <see cref="NullableVar&lt;T&gt;"/> class.
            /// </summary>
            /// <param name="defaultValue">The default value used when the specified key does not exist in the 
            /// specified sources.</param>
            /// <param name="key">The key for the stored value.</param>
            /// <param name="cookieLifeTime">
            /// The cookie life time. Its value is set to 100 days when a null value is specified.</param>
            /// <param name="cacheLifeTime">
            /// The cache life time. Its value is set to 20 minutes when a null value is specified.</param>
            /// <param name="targetTypes">Specifies the storage types where the value is allowed to be saved. 
            /// Those are hardcoded in the Targets class. Several types can be specified
            /// by adding them up using the '+' operator as such: 
            /// Targets.Cookie + Targets.Session + Targets.Cache</param>
            /// <param name="sourceTypes">A list of storage types from which the value will be retrieved
            /// Each type is hardcoded within the Sources enum and they must be seperated by a comma.
            /// The order in which they are listed determines the order in which they are accessed until a value is found.
            /// </param>
            public NullableVar(T defaultValue, string key, TimeSpan? cookieLifeTime, CacheDependency cacheDependency, TimeSpan? cacheLifeTime,
                int? targetTypeFlags, params Sources[] sourceTypes)
                : base(defaultValue, key, cookieLifeTime, cacheDependency, cacheLifeTime, targetTypeFlags, sourceTypes) { }

            public T? NullableValue
            {
                get
                {
                    Sources source;
                    T value = GetValue(_key, out source, _sourceTypes);
                    if (source != Sources.None)
                        return value;
                    else
                        return null;
                }
                set
                {
                    if (value.HasValue)
                        SetValue(_key, value.Value);
                    else
                        ClearTargets();
                }
            }
        }
    }
}