﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;
using System.Web.UI.WebControls;
using System.Web.UI;

namespace System.Web
{
    public partial class Local : LocalBase
    {
        /// <summary>
        /// This is still an experimental class that is meant to allow you to use
        /// an object property in the target and source list.
        /// </summary>
        /// <typeparam name="T">The generic type T for the variable.</typeparam>
        public class CompositeVar<T> : Var<T>
        {
            public List<object> TargetControls { get; set; }
            public object[] SourceObjects { get; set; }
            public string PropertyName { get; set; }

            public CompositeVar(string key, string propertyName, object targetObjects, params object[] sourceObjects)
                : this(default(T), key, propertyName, new List<object> { targetObjects }, sourceObjects) { }

            public CompositeVar(string key, string propertyName, List<object> targetObjects, params object[] sourceObjects)
                : this(default(T), key, propertyName, targetObjects, sourceObjects) { }

            public CompositeVar(T defaultValue, string key, string propertyName,
                List<object> targetObjects, params object[] sourceObjects)
                : base(defaultValue, key, null, null, null, null)
            {
                // Populate the TargetTypes & TargetControls list seperately
                if (targetObjects != null)
                {
                    foreach (object obj in targetObjects)
                        if (obj.GetType() == typeof(byte))
                            TargetTypes += (byte)obj;
                        else
                            TargetControls.Add(obj);
                }
                SourceObjects = sourceObjects;
            }

            public new T Value
            {
                get
                {
                    // Populate the SourceTypes & SourceControls list
                    if (SourceObjects != null)
                    {
                        object value;
                        foreach (object obj in SourceObjects)
                        {
                            if (obj.GetType() == typeof(Sources))
                            {
                                value = GetValue(Key, (Sources)obj);
                                if (value != null) 
                                    return (T)value;
                            }
                            else
                            {
                                value = Reflection.GetPropertyValue<object>(obj, PropertyName);
                                if (value != null)
                                {
                                    // Serialization is not applied on primitive or string types.
                                    // This allows json data to be stored in a hidden field as well.
                                    return Serialization.FromJsonString<T>(value.ToString());
                                }
                            }

                        }
                    }
                    return default(T);
                }
                set
                {
                    // Set the value for all target types
                    base.Value = value;
                    // Set the value for all target controls
                    foreach (object obj in TargetControls)
                    {
                        // Serialization is not applied on primitive or string types.
                        // This allows json data to be stored in a hidden field as well.
                        Reflection.SetPropertyValue<object>(obj, PropertyName, Serialization.ToJsonString<T>(value));
                    }
                }
            }

        }
    }
}