﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using System.Web.DynamicData;

public partial class Details : System.Web.UI.Page
{
    protected MetaTable table;

    protected void Page_Init(object sender, EventArgs e)
    {
        dynamicDataManager.RegisterControl(commonDetailsView);
        switch (Request.Url.Segments[3])
        {
            case "Insert.aspx":
                commonDetailsView.AutoGenerateInsertButton = true;
                commonDetailsView.ChangeMode(DetailsViewMode.Insert);
                break;
            case "Edit.aspx":
                commonDetailsView.AutoGenerateEditButton = true;
                commonDetailsView.ChangeMode(DetailsViewMode.Edit);
                break;
            case "Details.aspx":
                commonDetailsView.AutoGenerateEditButton = true;
                commonDetailsView.AutoGenerateDeleteButton = true;
                commonDetailsView.ChangeMode(DetailsViewMode.ReadOnly);
                break;
        }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        table = detailsDataSource.GetTable();
        Title = table.DisplayName;
        detailsDataSource.Include = table.ForeignKeyColumnsNames;
        ListHyperLink.NavigateUrl = table.ListActionPath;
    }

    protected void commonDetailsView_ItemDeleted(object sender, DetailsViewDeletedEventArgs e)
    {
        if (e.Exception == null || e.ExceptionHandled)
        {
            Response.Redirect(table.ListActionPath);
        }
    }

    protected void commonDetailsView_ItemInserted(object sender, DetailsViewInsertedEventArgs e)
    {
        if (e.Exception == null || e.ExceptionHandled)
        {
            Response.Redirect(table.ListActionPath);
        }
    }

    protected void commonDetailsView_ItemCommand(object sender, DetailsViewCommandEventArgs e)
    {
        if (e.CommandName == DataControlCommands.CancelCommandName)
        {
            Response.Redirect(table.ListActionPath);
        }
    }
    protected void commonDetailsView_ItemUpdated(object sender, DetailsViewUpdatedEventArgs e)
    {
        if (e.Exception == null || e.ExceptionHandled)
        {
            Response.Redirect(table.ListActionPath);
        }
    }
}
