﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Reflection;
using Pixysoft.Tools;

namespace Pixysoft.Reflection
{
    /// <summary>
    /// copyright 2009 by pixysoft (China)
    /// http://www.pixysoft.net
    /// 
    /// contact: reborn_zhang@hotmail.com
    /// </summary>
    public class ReflectHelper
    {
        private static volatile ReflectHelper instance;

        private static object syncRoot = new Object();

        public static ReflectHelper Instance
        {
            get
            {
                if (instance == null)
                {
                    lock (syncRoot)
                    {
                        instance = new ReflectHelper();
                    }
                }

                return instance;

            }
        }

        public bool IsBaseClass(Type type)
        {
            if (type == null)
                throw new Exception("missing input.");

            if (type.BaseType.Name.ToUpper() != "OBJECT" && type.BaseType.Name.ToUpper() != "VALUETYPE")
                return false;

            return true;
        }
    }
}
