﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Pixysoft.Tools
{
    /// <summary>
    /// copyright 2009 by pixysoft (China)
    /// http://www.pixysoft.net
    /// 
    /// contact: reborn_zhang@hotmail.com
    /// </summary>
    public class ParserHelper
    {
        public static bool TryParse<T>(object input, out T value)
        {
            value = default(T);

            object tempvalue = null;

            if (!TryParse(typeof(T), input, out tempvalue))
                return false;

            value = (T)tempvalue;

            return true;
        }

        public static bool TryParse(Type parsetype, object input, out object result)
        {
            result = null;

            if (input == null)
                return false;

            Type type = parsetype;

            if (typeof(int).Equals(type))
            {
                int _value = int.MinValue;

                if (!int.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(Int64).Equals(type))
            {
                Int64 _value = Int64.MinValue;

                if (!Int64.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(double).Equals(type))
            {
                double _value = double.MinValue;

                if (!double.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(bool).Equals(type))
            {
                bool _value = false;

                if (!bool.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(char).Equals(type))
            {
                char _value = char.MinValue;

                if (!char.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(byte).Equals(type))
            {
                byte _value = byte.MinValue;

                if (!byte.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(DateTime).Equals(type))
            {
                DateTime _value = DateTime.MinValue;

                if (!DateTime.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else if (typeof(float).Equals(type))
            {
                float _value = float.MinValue;

                if (!float.TryParse(input.ToString(), out _value))
                    return false;

                result = _value;
            }
            else
            {
                result = input;
            }

            return true;
        }

        public static bool TryParse(object input, out int value)
        {
            value = int.MinValue;

            if (!int.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        //public static bool TryParse(object input, out Int32 value)
        //{
        //    value = Int32.MinValue;

        //    if (!Int32.TryParse(input.ToString(), out value))
        //        return false;

        //    return true;
        //}

        public static bool TryParse(object input, out Int64 value)
        {
            value = Int64.MinValue;

            if (!Int64.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        public static bool TryParse(object input, out bool value)
        {
            value = false;

            if (!bool.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        public static bool TryParse(object input, out float value)
        {
            value = float.MinValue;

            if (!float.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        public static bool TryParse(object input, out double value)
        {
            value = double.MinValue;

            if (!double.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        public static bool TryParse(object input, out byte value)
        {
            value = byte.MinValue;

            if (!byte.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        public static bool TryParse(object input, out char value)
        {
            value = char.MinValue;

            if (!char.TryParse(input.ToString(), out value))
                return false;

            return true;
        }

        public static bool TryParse(object input, out DateTime value)
        {
            value = DateTime.MinValue;

            if (!DateTime.TryParse(input.ToString(), out value))
                return false;

            return true;
        }



    }
}
