using System;
using System.Collections.Generic;
using System.Text;
using System.Reflection;
using Pixysoft.Tools;

namespace Pixysoft.Reflection
{
    /// <summary>
    /// copyright 2009 by pixysoft (China)
    /// http://www.pixysoft.net
    /// 
    /// contact: reborn_zhang@hotmail.com
    /// </summary>
    public class MethodReflector
    {

        public static object GetValue(Type type, object obj, string method, params object[] parameters)
        {
            if (type == null)
                return null;

            if (obj == null)
                return null;

            if (string.IsNullOrEmpty(method))
                return null;

            MethodInfo info = type.GetMethod(method, BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Public);

            if (info == null)
                if (type.BaseType.Name.ToUpper() != "OBJECT" && type.BaseType.Name.ToUpper() != "VALUETYPE")
                {
                    return GetValue(type.BaseType, obj, method);
                }
                else
                {
                    return null;
                }

            //вת

            List<object> nparameters = GetValidArgs(info, parameters);

            object value = info.Invoke(obj, nparameters.ToArray());

            return value;
        }

        private static List<object> GetValidArgs(MethodInfo info, object[] parameters)
        {
            List<object> nparameters = new List<object>();

            int counter = 0;

            if (info.GetParameters().Length != parameters.Length)
                throw new Exception("input parameters do not fit for the method.");

            foreach (ParameterInfo pinfo in info.GetParameters())
            {
                object npara = null;

                if (ReflectHelper.Instance.IsBaseClass(pinfo.ParameterType))
                {
                    if (!ParserHelper.TryParse(pinfo.ParameterType, parameters[counter], out npara))
                    {
                        throw new Exception("cannot transform the input value to method. need type = " + pinfo.ParameterType.Name);
                    }
                }
                else
                {
                    //do nothing
                }

                nparameters.Add(npara);
            }
            return nparameters;
        }


        public static bool SetValue(object obj, string method, params object[] parameters)
        {
            if (obj == null || string.IsNullOrEmpty(method))
                return false;

            Type type = obj.GetType();

            return SetValue(type, obj, method, parameters);
        }

        public static bool SetValue(Type type, object obj, string method, params object[] parameters)
        {
            if (obj == null || string.IsNullOrEmpty(method))
                return false;

            if (type == null)
                return false;

            MethodInfo info = type.GetMethod(method, BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Public);

            if (info == null)
            {
                if (type.BaseType.Name.ToUpper() != "OBJECT" && type.BaseType.Name.ToUpper() != "VALUETYPE")
                {
                    return SetValue(type.BaseType, obj, method, GetValidArgs(info, parameters).ToArray());
                }
                else
                {
                    return false;
                }
            }

            try
            {
                info.Invoke(obj, parameters);

                return true;
            }
            catch
            {
                return false;
            }
        }


        public static List<string> GetMethods(Type type)
        {
            List<string> list = new List<string>();

            if (type == null)
                return list;

            foreach (MethodInfo info in type.GetMethods(BindingFlags.Instance | BindingFlags.Public))
            {
                list.Add(info.Name);
            }

            return list;
        }

        public static List<string> GetArgs(Type type, string method)
        {
            List<string> list = new List<string>();

            if (type == null || string.IsNullOrEmpty(method))
                return list;

            MethodInfo info = type.GetMethod(method, BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Public);

            if (info == null)
            {
                if (type.BaseType.Name.ToUpper() != "OBJECT" && type.BaseType.Name.ToUpper() != "VALUETYPE")
                {
                    return GetArgs(type, method);
                }
                else
                {
                    return list;
                }
            }

            try
            {
                foreach (ParameterInfo pinfo in info.GetParameters())
                {
                    list.Add(pinfo.Name);
                }

                return list;
            }
            catch
            {
                return list;
            }
        }


        public static bool HasReturn(Type type, string method)
        {
            if (type == null)
                throw new Exception(string.Format("missing method {0} for type {1}.", method, type));

            if (method == null)
                throw new Exception(string.Format("missing method {0} for type {1}.", method, type));

            MethodInfo info = type.GetMethod(method, BindingFlags.Instance | BindingFlags.NonPublic | BindingFlags.Public);

            if (info == null)
                throw new Exception(string.Format("missing method {0} for type {1}.", method, type));

            if (info.ReturnType == null)
                return false;

            return info.ReturnType.Name.Trim().ToUpper() != "VOID";
        }


    }

}
