﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="DNJRPCDemo.aspx.cs" Inherits="AjaxDemos_DNJRPCDemo" %>

<%@ Register assembly="Org.Eurekaa.DNJ" namespace="Org.Eurekaa.DNJ.WebControls" tagprefix="dnj" %>



<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>DNJRPC Demo page</title>
    <style type="text/css">
    #target
    {
        border:2px solid #0a0;
        background:#eee;
        display:block;
        width:400px;
        height:300px;
    }
    
    </style>
    
    <!-- Use the DNJResources axd to load jquery-->
	<script type="text/javascript" src="DNJResources.axd?load=jquery"></script>
	<script type="text/javascript" src="../../js/jquery.nyroModal-1.5.0.min.js"></script>		
	
	<!-- Use the DNJResources axd to generate DNJRPC scripts-->
	<script type="text/javascript" src="DNJResources.axd?conf=../../dnj/config/dnjrpc.conf.js"></script>
	
	<script type="text/javascript">   
	// JSON RPC bindings
    function showResult(data)
    {
        $('#target').html('<b>JSON Response : </b><br /><b>result</b> : ' + data.result + ' ; <b>errors</b> : '+data.error + ' ; <b>id</b> : '+data.id);
    }
    
     $(document).ready(function(){

       $('#Button1').bind('click', function(){
		    $.DNJRPC({success:showResult}).App_Code.includes.SayHello();
       });
       $('#Button2').bind('click', function(){
		    $.DNJRPC('#target').App_Code.includes.Say($('#str').val());

       });
       $('#Button3').bind('click', function(){
            $.DNJRPC('#result').App_Code.includes.Add($('#va').val() , $('#vb').val());
       });
       $('#Button4').bind('click', function(){
            $.DNJRPC({success:showResult}).package.BLProcess();
       });
    
                   
     });
        
	</script>    
	
    
	
</head>
<body>
    <form id="form1" runat="server">
        <table style="width:100%;">
            <tr>
                <td>
                    <b>Some RPC examples</b><br />
                    Call BLProcess() from external dll (process.dll)<br />
                    <input id="Button4" type="button" value="BLProcess"/>
                    <br />
                    <br />
                    Call SayHello() from App_Code<br />
                    <input id="Button1" type="button" value="SayHello"/>
                    <br />
                    <br />
                    Call Say(string something) from App_Code<br />
                    <input id="str" type="text" value="Eurekaa!" /><input id="Button2" type="button" value="Say"/>
                    <br />
                    <br />
                    Call Add(int a, int b)&nbsp; or Add(float a, float b) depending on entered parameters
                    from App_Code<br />
                    <input id="va" style="width: 27px" type="text" value="5" />
                    +
                    <input id="vb" style="width: 31px" type="text" value="56" />
                    <input id="Button3" type="button" value="Add"/>
                    <input id="result" style="width: 60px" type="text" value="" />
                    <br />
                </td>
                <td>
                    <b>Target for all remote calls</b>
                    <div id="target"></div>              
                    
                </td>
            </tr>

        </table>
        <br />
        Note that all functions are done server side using a json-rpc request. then we gat
        back a json-rpc response with the result and the error status.<br />
        <br />
        Server side namespaces are preserved :
        <br />
        For example if you define a method called Hello() in a namespace called NS.MyMethods
        packaged into an assambly called MyAssembly.dll ; then the javascript call will
        be something like :
        <br />
        $.DNJRPC('#target').MyAssembly.NS.MyMethods.Hello();<br />
        <br />
        </form>

</body>
</html>
