﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="DNJPanelDemo.aspx.cs" Inherits="AjaxDemos_DNJPanelDemo" %>

<%@ Register assembly="Org.Eurekaa.DNJ" namespace="Org.Eurekaa.DNJ.WebControls" tagprefix="dnj" %>



<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head id="Head1" runat="server">
    <title>DNJ Demo page</title>
    <link href="nyroModal/nyroModal.full.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
    .dnj-indicator
    {
        border:0px;
        background: #a00;
        color:#fff;
        position:absolute;
        top:0px;
        right:0px;
        width:150px;
        font:700 11px verdana;
        padding:2px 5px;
    }
    h3
    {
    	color:#b33;
    	margin-bottom:5px;
    	padding-bottom:5px;
    }
    </style>
    
    <!-- Use the DNJResources axd to load jquery-->
	<script type="text/javascript" src="DNJResources.axd?load=jquery"></script>
	<script type="text/javascript" src="nyroModal/jquery.nyroModal-1.5.0.min.js"></script>		
	
	
	<script type="text/javascript">   
        $(document).ready(function() {    
        
        //Creating a custom ajax indicator (à la GMail "loading" indicator)
        var indicator = $('<div>Loading</div>').addClass('dnj-indicator').hide();
        $('body').append(indicator);
        $(window).scroll(function() {
            indicator.css('top', $(this).scrollTop() + "px");
        });                                         


	    // Custom DNJ ajaxifier initialisation
	    // Note that we can activate DNJ by simple $.DNJ() call
	    // The example bellow shows how we can add some visual effects for loading, waiting, errors ...etc
	    //       
        $.DNJ.settings.beforeCallBack = function(sender)
                {
                    indicator.show();
                    sender.fadeTo("fast", 0.50);
                };
        $.DNJ.settings.afterCallBack = function(sender)
                {
                    indicator.hide();
                };
        $.DNJ.settings.errorCallBack = function(msg) {
                    $.nyroModalManual({
                      bgColor: '#ffaaaa',
                      title: 'An error has occured',
                      content: msg
                    });            
                };
                
        
   });     
	</script>        
	
    
	
</head>
<body>
    <form id="form1" runat="server">
                    <h1>Ajaxified content with custom loading indicator and error callback</h1>
                    <p>
                    Bellow some standard asp.net controls, ajaxified simply by putting them inside a DNJPanel
                    (delimitted with a dashed border)<br />
                    </p>
                    <p>
                    The example shows the possibility to customize the behaviour of DNJPanel by overloading client Callback functions : beforeCallBack,afterCallBack, errorCallBack and successCallBack.<br />                    
                    </p>
                    <dnj:DNJPanel ID="DNJPanel1" runat="server" BackColor="#F3F3F3" 
                        BorderColor="Black" BorderStyle="Dashed">
                        <h3>Standard Calendar control</h3><asp:Calendar ID="Calendar1" runat="server" 
                            BackColor="#FFFFCC" BorderColor="#FFCC66" BorderWidth="1px" 
                            DayNameFormat="Shortest" Font-Names="Verdana" Font-Size="8pt" 
                            ForeColor="#663399" Height="200px" ShowGridLines="True" Width="220px">
                            <SelectedDayStyle BackColor="#CCCCFF" Font-Bold="True" />
                            <SelectorStyle BackColor="#FFCC66" />
                            <TodayDayStyle BackColor="#FFCC66" ForeColor="White" />
                            <OtherMonthDayStyle ForeColor="#CC9966" />
                            <NextPrevStyle Font-Size="9pt" ForeColor="#FFFFCC" />
                            <DayHeaderStyle BackColor="#FFCC66" Font-Bold="True" Height="1px" />
                            <TitleStyle BackColor="#990000" Font-Bold="True" Font-Size="9pt" 
                                ForeColor="#FFFFCC" />
                        </asp:Calendar>
                        <h3>Read date from calendar control</h3>
                        &nbsp;<asp:Button ID="Button5" runat="server" OnClick="Button5_Click" 
                                Text="Get Date" />
                            <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox>
                        <br />
                        <br />
                        <h3>Copy source text to target after a thread.sleep of two seconds</h3>
                        <asp:TextBox ID="TxtSource" runat="server">Source</asp:TextBox>
                        <asp:Button ID="BtnCopy" runat="server" onclick="BtnCopy_Click" 
                            Text="Copy with delay" />
                        <asp:TextBox ID="TxtTarget" runat="server">Target</asp:TextBox>
                        <br />
                        <h3>Exception example</h3>&nbsp;
                            <asp:LinkButton ID="LinkButton1" runat="server" OnClick="LinkButton1_Click">Throw 
                        exception example</asp:LinkButton>
                        &nbsp;(use nyromodal plugin to show the error).<br />
                        <br />
                    </dnj:DNJPanel>    
    
        </form>

</body>
</html>

