<%@ WebHandler Language="C#" Class="Service" %>
using System;
using System.Web;
using System.Net;
using System.IO;
using System.Web.Script.Serialization;


public class Service : IHttpHandler
{
    public bool IsReusable
    {
        get
        {
            return true;
        }
    }
    
    protected string ToJson(object target)
    {
        JavaScriptSerializer s = new JavaScriptSerializer();
        return s.Serialize(target);
    }
    
    public string GetPage(string url)
    { 
        HttpWebRequest req = (HttpWebRequest)WebRequest.Create(url);
        using (HttpWebResponse res = (HttpWebResponse)req.GetResponse())
        {
            StreamReader sr = new StreamReader(res.GetResponseStream());
            return (sr.ReadToEnd());
        }
    }

    public void ProcessRequest(HttpContext context)
    {
        string callbackMethodName = context.Request.Params["method"];
        string url = context.Request.Params["downloadurl"];
        context.Response.ContentType = "application/x-javascript";
        context.Response.Write(callbackMethodName);
        context.Response.Write("( ");
        context.Response.Write(ToJson(GetPage(url)));
        context.Response.Write(" );");
    }
}