﻿using System.ServiceModel;
using System.ServiceModel.Web;
using System.Runtime.Serialization;
using System;
using System.Web.Services;
using Microsoft.Jsonp;

namespace Widgets
{
    [ServiceContract]
    public interface ICalculator2
    {
        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json)]
        [JSONPBehavior(callback = "method")]
        Result Sum(string arg1, string arg2);
    }

    [DataContract]
    public class Result
    {
        public Result() { }

        [DataMember]
        public string Error;

        [DataMember]
        public string Value;
    }

    // Service Implementation
    public class Calculator2 : ICalculator2
    {
        public Calculator2() { }

        public Result Sum(string arg1, string arg2)
        {
            Result result = new Result();
            try
            {
                int iarg1 = 0;
                int iarg2 = 0;
                int.TryParse(arg1, out iarg1);
                int.TryParse(arg2, out iarg2);
                result.Value = (iarg1 + iarg2).ToString();
            }
            catch (Exception ex)
            {
                result.Error = ex.Message;
            }
            return result;
        }
    }
}
