﻿using System;
using DotNetNuke.Entities.Modules;

namespace HelloWorld3
{
    public partial class View : PortalModuleBase
    {
        public string SilverlightApplication { get; set; }
        public string SilverlightInitParams { get; set; }

        protected void Page_Load(object sender, EventArgs e)
        {
            // Register Silverlight.js file
            Page.ClientScript.RegisterClientScriptInclude(this.GetType(), "SilverlightJS",
                (this.TemplateSourceDirectory + "/Silverlight.js"));

            // Set the Web Service URL
            string strWebServiceURL = String.Format(@"http://{0}{1}", this.PortalAlias.HTTPAlias,
                "/DesktopModules/HelloWorld3/WebService.asmx");

            // Set the path to the .xap file
            SilverlightApplication = String.Format("{0}{1}", TemplateSourceDirectory,
                "/ClientBin/HelloWorld3.xap");

            // Pass the Initialization Parameters to the Silverlight Control
            SilverlightInitParams = string.Format("WebServiceURL={0}", strWebServiceURL);
        }
    }
}