﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.Linq;
/// <summary>
/// Implements IDisplay interface which 
/// </summary>
public partial class RegisterUser : System.Web.UI.Page, IDisplay
{
    protected void Page_Load(object sender, EventArgs e)
    {

    }

    protected void ButtonRegister_Click(object sender, EventArgs e)
    {
        string uniqueName = TextBoxUniqueName.Text.Trim();
        DataClassesDataContext dc = new DataClassesDataContext();
        //getting users using unique name given by user.
        var users = from u in dc.Users
                    where u.UniqueName == uniqueName
                    select u;
        if (users.Count<User>() == 0)
        {
            //Registering new user
            User user = new User();
            user.UniqueName = uniqueName;
            user.Name = TextBoxFullName.Text;
            user.Summary = TextBoxSummary.Text;
            dc.Users.InsertOnSubmit(user);
            dc.SubmitChanges();
            LabelMessage.Text = "Congratulations! The Name '" + uniqueName + "' is registered successfully.";
            TextBoxFullName.Text = "";
            TextBoxUniqueName.Text = "";
            TextBoxSummary.Text = "";
            LinqDataSource1.DataBind();
            GridViewUserList.DataBind();
        }
        else
        {
            //unique name not available
            LabelMessage.Text = "Sorry! The Name '" + uniqueName + "' is not available.";
        }
    }
}
