﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Routing;
using System.Web.Compilation;
using System.Web.UI;

/// <summary>
/// Summary description for RouteHandler
/// </summary>
public class UserRouteHandler : IRouteHandler
{
    public UserRouteHandler()
    {

    }
    public UserRouteHandler(string virtualPath)
    {
        _virtualPath = virtualPath;
    }

    public IHttpHandler GetHttpHandler(RequestContext requestContext)
    {
        if (requestContext.RouteData.Values["name"] != null)
        {
            var display = BuildManager.CreateInstanceFromVirtualPath(
                            _virtualPath, typeof(Page)) as IUserDisplay;
            if (display != null)
            {
                display.UniqueName = requestContext.RouteData.Values["name"] as string;
                return display;
            }
            else
            {
                return null;
            }
        }
        else
        {
            return null;
        }
    }

     string _virtualPath;
}

