﻿using System;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Configuration;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // you can use your custom section in anywhere
    }

    protected void btnGetConfig_Click(object sender, EventArgs e)
    {
        // "~/" this is the root path for loading web.config file
        Configuration config = WebConfigurationManager.
            OpenWebConfiguration("~/");
        if (config.HasFile)
        {
            // get custom section from web.config file
            // and cast it to the specifid class
            CustomServiceProvider csp =
                (CustomServiceProvider)config.
                GetSection("customServiceProvider");
            //if custom section successfully loaded to the object
            if (csp != null)
            {
                // load the custom sections attributes to the page on runtime.
                txtUri.Text = csp.Uri;
                txtStatus.Text = csp.Status.ToString();
                txtPort.Text = csp.Port.ToString();
            }
        }
    }

    protected void chkEncryptSection_CheckedChanged(object sender, EventArgs e)
    {
        Configuration config = WebConfigurationManager.
            OpenWebConfiguration("~/");
        if (config.HasFile)
        {
            // load custom section to the object
            CustomServiceProvider csp =
                (CustomServiceProvider)config.
                GetSection("customServiceProvider");

            // now if you request for encrypt config section
            if (chkEncryptSection.Checked)
            {
                if (!csp.SectionInformation.IsProtected)
                    csp.SectionInformation.ProtectSection
                        ("DataProtectionConfigurationProvider");
                Response.Write("Protected Custom Section " +
                    "\"customServiceProvider\"");
            }
            else
            {
                if (csp.SectionInformation.IsProtected)
                    csp.SectionInformation.UnprotectSection();
                Response.Write("Unprotected Custom Section " +
                    "\"customServiceProvider\"");
            }
            config.Save();
        }
    }

    protected void chkEncryptConnStr_CheckedChanged(object sender, EventArgs e)
    {
        Configuration config = WebConfigurationManager.
            OpenWebConfiguration("~/");
        if (config.HasFile)
        {
            // load the connection string section 
            // to the object and then encrypt or decrypt it.
            ConfigurationSection connStr =
                config.GetSection("connectionStrings");
            if (chkEncryptConnStr.Checked)
            {
                if (!connStr.SectionInformation.IsProtected)
                    connStr.SectionInformation.ProtectSection
                        ("DataProtectionConfigurationProvider");
                Response.Write("Protect ConnectionString.");
            }
            else
            {
                if (connStr.SectionInformation.IsProtected)
                    connStr.SectionInformation.UnprotectSection();
                Response.Write("Unprotected ConnectionString.");
            }
            config.Save();
        }
    }
}
