/****************************************/

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TaskItem](
	[ItemID] [int] NOT NULL,
	[Title] [nvarchar](max) NOT NULL,
	[Priority] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[DueDate] [datetime] NULL,
	[PercentCompleted] [int] NULL,
	[TrackProgress] [bit] NULL,
	[RemindOnDelay] [bit] NULL,
	[IsAccomplished] [bit] NULL,
 CONSTRAINT [PK_ToDoItem] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

/****************************************/

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE TABLE [dbo].[TrashedTaskItem](
	[ItemID] [int] NOT NULL,
	[Title] [nvarchar](max) NOT NULL,
	[Priority] [int] NOT NULL,
	[StartDate] [datetime] NOT NULL,
	[DueDate] [datetime] NULL,
	[PercentCompleted] [int] NULL,
	[TrackProgress] [bit] NULL,
	[RemindOnDelay] [bit] NULL,
	[IsAccompolished] [bit] NULL,
 CONSTRAINT [PK_TrashedTaskItem] PRIMARY KEY CLUSTERED 
(
	[ItemID] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO
ALTER TABLE [dbo].[TrashedTaskItem]  WITH CHECK ADD  CONSTRAINT [FK_TTI_TI] FOREIGN KEY([ItemID])
REFERENCES [dbo].[TaskItem] ([ItemID])
GO
ALTER TABLE [dbo].[TrashedTaskItem] CHECK CONSTRAINT [FK_TTI_TI]

/****************************************/
/****************************************/
/**** LEGACY STORED PROCs ***************/
/****************************************/
/***** NOT USED NOW *********************/
/****************************************/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[DeleteToDoItem]
	(
  	@itemId int
	)
AS
  DELETE FROM ToDoItem
    WHERE ItemId = @itemId
	RETURN
GO

/****************************************/

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[InsertToDoItem]
	(
  	@title nvarchar(MAX),
	  @priority int,
	  @startDate datetime,
	  @dueDate datetime = null,
	  @percentCompleted int = null,
	  @trackProgress bit = null,
	  @remindOnDelay bit = null
	)
AS
  DECLARE @itemId int
  
  SELECT @itemId = ISNULL(MAX(ItemId),0) FROM ToDoItem
  SET @itemId = @itemId + 1
  
  INSERT INTO ToDoItem(ItemId, Title, Priority, StartDate, DueDate,
    PercentCompleted, TrackProgress, RemindOnDelay) VALUES(
      @itemId, @title, @priority, @startDate, @dueDate,
      @percentCompleted, @trackProgress, @remindOnDelay)

	RETURN
GO

/****************************************/

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[UpdateToDoItem]
	(
  	@itemId int,
	  @title nvarchar(max),
	  @priority int,
	  @startDate datetime,
	  @dueDate datetime = null,
	  @percentCompleted int = null,
	  @trackProgress bit = null,
	  @remindOnDelay bit = null
	)
AS
  UPDATE ToDoItem
    SET Title = @title,
        Priority = @priority,
        StartDate = @startDate,
        DueDate = @dueDate,
        PercentCompleted = @percentCompleted,
        TrackProgress = @trackProgress,
        RemindOnDelay = @remindOnDelay
  WHERE ItemId = @itemId
  
	RETURN
GO

/****************************************/

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[SelectToDoItem]
	@itemId int
AS
BEGIN
	SET NOCOUNT ON;

    SELECT	* FROM ToDoItem WHERE	
	  ToDoItem.ItemId = @itemId
END
GO

/****************************************/

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[SelectActiveItems]
AS
  SELECT * FROM ToDoItem
	RETURN
GO

/****************************************/