﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" 
  AutoEventWireup="true" CodeBehind="Index.aspx.cs"
  Inherits="DevOrigin.ToDoList.Web.Views.Index" %>

<asp:Content ID="itemTitle" ContentPlaceHolderID="TitleContent" runat="server">
  /dev/root - todolist
</asp:Content>
<asp:Content ID="itemContent" ContentPlaceHolderID="MainContent" runat="server">
  <h1>
    todolist items</h1>
  <table class="display" width="100%" id="taskList" cellpadding="0" cellspacing="0" border="0">
    <thead>
      <tr>
        <th>
        </th>
        <%--<th>
                ItemID
            </th>--%>
        <th>
          Title
        </th>
        <th>
          Priority
        </th>
        <th>
          Start Date
        </th>
        <th>
          Due Date
        </th>
        <th>
          % Completed
        </th>
      </tr>
    </thead>
    <tbody>
      <% foreach (var item in ViewData.Model)
         { %>
      
      <%if (item.TaskItem.IsAccomplished == true)
        {
          Response.Write("<tr class='accomplished'>");
        }
        else
        {
          Response.Write("<tr>");
        }%>
        
        <td>
          <%if (item.TaskItem.IsAccomplished == true)
            { %>
            <% Response.Write("done"); %>
          <%}
            else
            { %>
          <%= Html.ActionLink("accomplish", "Accomplish", new { id = item.TaskItem.ItemId })%>
          <%} %>
          | <%= Html.ActionLink("edit", "Edit", new { id = item.TaskItem.ItemId })%>
        </td>
        <td>
          <%= Html.ActionLink(Html.Encode(item.TaskItem.Title), "Details", new { id = item.TaskItem.ItemId })%>
        </td>
        <td>
          <%= item.GetPriorityByName(item.TaskItem.Priority) %>
        </td>
        <td>
          <%= Html.Encode(String.Format("{0:dd/MMM/yyyy}", item.TaskItem.StartDate))%>
        </td>
        <td>
          <%= Html.Encode(String.Format("{0:dd/MMM/yyyy}", item.TaskItem.DueDate))%>
        </td>
        <td>
          <%= Html.Encode(item.TaskItem.PercentCompleted)%>%
        </td>
      </tr>
      <% } %>
    </tbody>
  </table>

  <script type="text/javascript" charset="utf-8">
    var oTable;
    var giRedraw = false;
    
    $(document).ready(function() {
      /* Add a click handler to the rows - this could be used as a callback */
      $("#taskList tbody").click(function(event) {
        $(oTable.fnSettings().aoData).each(function() {
          $(this.nTr).removeClass('row_selected');
        });
        $(event.target.parentNode).addClass('row_selected');
      });

      oTable = $('#taskList').dataTable({
        "bFilter": false
      });
    });

    /* Get the rows which are currently selected */
    function fnGetSelected(oTableLocal) {
      var aReturn = new Array();
      var aTrs = oTableLocal.fnGetNodes();

      for (var i = 0; i < aTrs.length; i++) {
        if ($(aTrs[i]).hasClass('row_selected')) {
          aReturn.push(aTrs[i]);
        }
      }
      return aReturn;
    }
  </script>
  <div class="spacer30"></div>
  <div class="spacer30"></div>
  <p>
    <%= Html.ActionLink("Create Task", "Create") %>
  </p>
</asp:Content>
