<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<DevOrigin.ToDoList.Data.TaskItemViewModel>" %>

<asp:Content ID="editTitle" ContentPlaceHolderID="TitleContent" runat="server">
  /dev/root - todolist
</asp:Content>
<asp:Content ID="editContent" ContentPlaceHolderID="MainContent" runat="server">
  <h1>Edit Task</h1>
  
  <%= Html.ValidationSummary("Edit was unsuccessful. Please correct the errors and try again.") %>
  <% using (Html.BeginForm())
     {%>
    <table width="100%" border="0">
      <tr>
        <td>
          <label for="Title">
            Title:</label></td>
          <td><%= Html.TextBox("Title", Model.TaskItem.Title) %>
          <%= Html.ValidationMessage("Title", "*") %>
        </td>
        <td>
          &nbsp;
        </td>
        <td>
          <label for="Priority">
            Priority:</label></td>
          <td><%= Html.DropDownList("Priority", Model.PriorityList)%>
          <%= Html.ValidationMessage("Priority", "*") %>
        </td>
      </tr>
      <tr>
        <td>
          <label for="StartDate">
            Start Date:</label></td>
          <td><%= Html.TextBox("StartDate", Model.TaskItem.StartDate.ToShortDateString())%>
          <%= Html.ValidationMessage("StartDate", "*") %>
        </td>
        <td>
          &nbsp;
        </td>
        <td>
          <label for="DueDate">
            Due Date:</label></td>
          <td>
          <%if (Model.TaskItem.DueDate != null)
            { %>
          <%= Html.TextBox("DueDate", Model.TaskItem.DueDate.Value.ToShortDateString())%>
          <%}
            else
            { %>
          <%= Html.TextBox("DueDate", Model.TaskItem.DueDate)%>
          <%} %>
          <%= Html.ValidationMessage("DueDate", "*") %>
        </td>
      </tr>
      <tr>
        <td>
          <label for="PercentCompleted">
            % Completed:</label></td>
          <td><%= Html.TextBox("PercentCompleted", Model.TaskItem.PercentCompleted)%>
          <%= Html.ValidationMessage("PercentCompleted", "*") %>
        </td>
        <td>
          &nbsp;
        </td>
        <td>
          <label for="TrackProgress">
            Track Progress:</label></td>
          <td><%= Html.CheckBox("TrackProgress", Model.TaskItem.TrackProgress)%>
        </td>
      </tr>
      <tr>
        <td>
          <label for="RemindOnDelay">
            Show Reminder:</label></td>
          <td><%= Html.CheckBox("RemindOnDelay", Model.TaskItem.RemindOnDelay)%>
        </td>
        <td colspan="3">&nbsp;</td>
      </tr>
      <tr>
        <td colspan="5">&nbsp;</td>
      </tr>
      <tr>
        <td>
          <input type="submit" value="Save Now" />
        </td>
        <td>
          <%=Html.ActionLink("Back", "Index") %>
        </td>
        <td colspan="3">&nbsp;</td>
      </tr>
    </table>
  <% } %>
</asp:Content>
