<%@ Page Title="" Language="C#" MasterPageFile="~/Views/Shared/Site.Master" Inherits="System.Web.Mvc.ViewPage<DevOrigin.ToDoList.Data.TaskItemViewModel>" %>

<asp:Content ID="itemTitle" ContentPlaceHolderID="TitleContent" runat="server">
  /dev/root - todolist
</asp:Content>
<asp:Content ID="itemContent" ContentPlaceHolderID="MainContent" runat="server">
  <h1>
    todolist - create item</h1>
  <%= Html.ValidationSummary("Create was unsuccessful. Please correct the errors and try again.") %>
  <% using (Html.BeginForm())
     {%>
    <table width="100%" border="0">
      <tr>
        <td>
          <label for="Title">
            Title:</label></td>
          <td><%= Html.TextBox("Title") %>
          <%= Html.ValidationMessage("Title", "*") %>
        </td>
        <td>
          &nbsp;
        </td>
        <td>
          <label for="Priority">
            Priority:</label></td>
          <td><%= Html.DropDownList("Priority", Model.PriorityList, "--Select One---") %>
          <%= Html.ValidationMessage("Priority", "*") %>
        </td>
      </tr>
      <tr>
        <td>
          <label for="StartDate">
            Start Date:</label></td>
          <td><%= Html.TextBox("StartDate") %>
          <%= Html.ValidationMessage("StartDate", "*") %>
        </td>
        <td>
          &nbsp;
        </td>
        <td>
          <label for="DueDate">
            Due Date:</label></td>
          <td><%= Html.TextBox("DueDate") %>
          <%= Html.ValidationMessage("DueDate", "*") %>
        </td>
      </tr>
      <tr>
        <td>
          <label for="PercentCompleted">
            % Completed:</label></td>
          <td><%= Html.TextBox("PercentCompleted") %>
          <%= Html.ValidationMessage("PercentCompleted", "*") %>
        </td>
        <td>
          &nbsp;
        </td>
        <td>
          <label for="TrackProgress">
            Track Progress:</label></td>
          <td><%= Html.CheckBox("TrackProgress", true) %>
        </td>
      </tr>
      <tr>
        <td>
          <label for="RemindOnDelay">
            Show Reminder:</label></td>
          <td><%= Html.CheckBox("RemindOnDelay", true) %></td>
          <td colspan="3">&nbsp;
        </td>
      </tr>
      <tr>
        <td colspan="5">&nbsp;</td>
      </tr>
      <tr>
        <td>
          <input type="submit" value="Save Now" />
        </td>
        <td>
          <%=Html.ActionLink("Back", "Index") %>
        </td>
        <td colspan="3">&nbsp;</td>
      </tr>
    </table>
  <% } %>
</asp:Content>
