﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Web.Routing;
using DevOrigin.ToDoList.Service;

namespace DevOrigin.ToDoList.Web
{
  // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
  // visit http://go.microsoft.com/?LinkId=9394801

  public class GlobalApplication : System.Web.HttpApplication
  {
    public static void RegisterRoutes(RouteCollection routes)
    {
      routes.IgnoreRoute("{resource}.axd/{*pathInfo}");

      routes.MapRoute(
        "ToDoItemShow",
        "ToDoItem/Details/{id}",
        new { controller = "ToDoItem", action = "Details" },
        new { page = @"\d.*" }
        );

      routes.MapRoute(
          "Default",                                              // Route name
          "{controller}/{action}/{id}",                           // URL with parameters
          new { controller = "Home", action = "Index", id = "" }  // Parameter defaults
      );
    }

    protected void Application_Start()
    {
      RegisterRoutes(RouteTable.Routes);

      Bootstrapper.ConfigureStructureMap();
      ControllerBuilder.Current.SetControllerFactory(
        new DevOrigin.ToDoList.Web.Controllers.StructureMapControllerFactory()
        );

      GetLogger().Info("Application is starting.");
    }

    protected void Application_End()
    {
      GetLogger().Info("App is shutting down.");
    }

    protected void Application_Error()
    {
      Exception lastException = Server.GetLastError();
      GetLogger().Fatal(lastException);
    }

    ILogger GetLogger()
    {
      return StructureMap.ObjectFactory.GetInstance<ILogger>();
    }
  }
}