﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace DevOrigin.ToDoList.Data
{
  public class TrashedTaskItemViewModel
  {
    public TrashedTaskItem TrashedTaskItem { get; private set; }
    public TaskItem TaskItem { get; private set; }
    public SelectList PriorityList { get; private set; }

    private List<Priority> Priorities = new List<Priority>();

    private void Initialize()
    {
      Priorities.Add(new Priority { Id = 1, Name = "General" });
      Priorities.Add(new Priority { Id = 2, Name = "Urgent" });
      Priorities.Add(new Priority { Id = 3, Name = "Critical" });
    }

    public string GetPriorityByName(int index)
    {
      foreach (Priority priority in Priorities)
        if (priority.Id == index)
          return priority.Name;

      return null;
    }

    public int GetPriorityById(int index)
    {
      foreach (Priority priority in Priorities)
        if (priority.Id == index)
          return priority.Id;

      return 0;
    }

    #region .ctor
    public TrashedTaskItemViewModel(TrashedTaskItem taskItem, int selectedIndex)
    {
      TrashedTaskItem = taskItem;
    }

    public TrashedTaskItemViewModel(TaskItem taskItem, int selectedIndex)
      : this(selectedIndex)
    {
      TaskItem = taskItem;
    }

    public TrashedTaskItemViewModel(int selectedIndex)
    {
      //Initialize the priorities list.
      Initialize();

      PriorityList =
        new SelectList(Priorities, "Id", "Name", selectedIndex);
    }
    #endregion

    public IList<TrashedTaskItemViewModel> GetList(IList<TrashedTaskItem> taskList)
    {
      List<TrashedTaskItemViewModel> list = new List<TrashedTaskItemViewModel>();

      foreach (TrashedTaskItem item in taskList)
        list.Add(new TrashedTaskItemViewModel(item, -1));

      return list;
    }

    class Priority
    {
      public int Id { get; set; }
      public string Name { get; set; }
    }
  }
}
