﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace DevOrigin.ToDoList.Data
{
  public class TaskItemViewModel
  {
    public TaskItem TaskItem { get; private set; }
    public SelectList PriorityList { get; private set; }

    private List<Priority> Priorities = new List<Priority>();

    private void Initialize()
    {
      Priorities.Add(new Priority { Id = 1, Name = "General" });
      Priorities.Add(new Priority { Id = 2, Name = "Urgent" });
      Priorities.Add(new Priority { Id = 3, Name = "Critical" });
    }

    public string GetPriorityByName(int index)
    {
      foreach (Priority priority in Priorities)
        if (priority.Id == index)
          return priority.Name;

      return null;
    }

    public int GetPriorityById(int index)
    {
      foreach (Priority priority in Priorities)
        if (priority.Id == index)
          return priority.Id;

      return 0;
    }

    public TaskItemViewModel(TaskItem taskItem, int selectedIndex)
    {
      //Initialize the priorities list.
      Initialize();

      TaskItem = taskItem;
      PriorityList =
        new SelectList(Priorities, "Id", "Name", selectedIndex);
    }

    public TaskItemViewModel()
    {
      //default .ctor
      //empty!!
    }

    public IList<TaskItemViewModel> GetList(IList<TaskItem> taskList)
    {
      List<TaskItemViewModel> list = new List<TaskItemViewModel>();

      foreach (TaskItem item in taskList)
        list.Add(new TaskItemViewModel(item, -1));

      return list;
    }

    class Priority
    {
      public int Id { get; set; }
      public string Name { get; set; }
    }
  }
}
