﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace DevOrigin.ToDoList.Web.Controllers
{
  [HandleError]
  public class HomeController : Controller
  {
    public ActionResult Index()
    {
      ViewData["Message"] = "Welcome to ASP.NET MVC!";

      return View();
    }

    public ActionResult About()
    {
      return View();
    }

    protected override void HandleUnknownAction(string actionName)
    {
      ViewData["Title"] = "Error 404 - Page not found";
      ViewData["Message"] = "Page not found";
      ViewData["RequestedAction"] = actionName;
      ViewData["Controller"] = "Home";
      ViewData["AlternativeActions"] = new string[] { "Index", "About" };
      Response.StatusCode = 404;
      View("404").ExecuteResult(ControllerContext);
    }
  }
}
