﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DevOrigin.ToDoList.Data
{
  public partial class TrashedTaskItem
  {
    public int ItemId { get; set; }
    public string Title { get; set; }
    public int Priority { get; set; }
    public DateTime StartDate { get; set; }
    public DateTime? DueDate { get; set; }
    public int? PercentCompleted { get; set; }
    public bool? TrackProgress { get; set; }
    public bool? RemindOnDelay { get; set; }
    public bool? IsAccomplished { get; set; }

    #region object overrides
    public override bool Equals(object obj)
    {
      if (obj is TrashedTaskItem)
      {
        TrashedTaskItem item = (TrashedTaskItem)obj;
        return item.ItemId == this.ItemId;
      }

      return base.Equals(obj);
    }

    public override string ToString()
    {
      return this.Title;
    }

    public override int GetHashCode()
    {
      return this.ItemId.GetHashCode();
    }
    #endregion
  }
}
