﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DevOrigin.ToDoList.Data.SqlRepository;

namespace DevOrigin.ToDoList.Data
{
  public class SqlTrashedTaskItemRepository : ITrashedTaskItemRepository
  {
    LinqTaskItemDataContext _db;

    /// <summary>
    /// One-arg CTOR for initialising the data context to be used for
    /// various methods.
    /// </summary>
    /// <param name="dataContext">TaskItem datacontext.</param>
    public SqlTrashedTaskItemRepository(LinqTaskItemDataContext dataContext)
    {
      //override the current context
      //with the one passed in
      _db = dataContext;
    }

    #region ITrashedTaskItemRepository Members

    /// <summary>
    /// Linq to SQL implementation for ToDoItem.
    /// </summary>
    /// <returns>TrashedTaskItem as Querable.</returns>
    public IQueryable<TrashedTaskItem> GetItems()
    {
      var items = from todoItem in _db.TrashedTaskItems
                  select new TrashedTaskItem
                  {
                    ItemId = todoItem.ItemID,
                    Title = todoItem.Title,
                    Priority = todoItem.Priority,
                    StartDate = todoItem.StartDate,
                    DueDate = todoItem.DueDate,
                    PercentCompleted = todoItem.PercentCompleted,
                    TrackProgress = todoItem.TrackProgress,
                    RemindOnDelay = todoItem.RemindOnDelay,
                    IsAccomplished = todoItem.IsAccompolished
                  };

      return items;
    }

    public void InsertTaskItem(TrashedTaskItem item)
    {
      throw new NotImplementedException();
    }

    public void UpdateTaskItem(TrashedTaskItem item)
    {
      throw new NotImplementedException();
    }

    public void Delete(int itemId)
    {
      throw new NotImplementedException();
    }

    #endregion
  }
}
