﻿function showDebug(sender, debugPaneName) {
    var debugPane = getControl(debugPaneName);

    if (debugPane.style.display == 'block') {
        hideDebug(debugPane);
    }
    else {
        setPositionOffset(debugPane, sender, 5, 5);
        debugPane.style.display = 'block';
        hideOverlap(debugPane);
    }
}

function hideDebugByName(debugPaneName) {
    hideDebug(getControl(debugPaneName));
}

function hideDebug(debugPaneName) {
    debugPaneName.style.display = 'none';
}

function hideOverlap(debugPane) {
    var divs = document.getElementsByTagName("div");

    for (var i = 0; i < divs.length; i++) {
        var div = divs[i];
        if (div != debugPane && div.debugPane == "true") {
            if (hitTest(div, debugPane)) {
                hideDebug(div);
            }
        }
    }
}

function hitTest(o, l){
	function getOffset(o){
		for(var r = {l: o.offsetLeft, t: o.offsetTop, r: o.offsetWidth, b: o.offsetHeight};
			o = o.offsetParent; r.l += o.offsetLeft, r.t += o.offsetTop);
		return r.r += r.l, r.b += r.t, r;
	}
	for(var b, s, r = [], a = getOffset(o), j = isNaN(l.length), i = (j ? l = [l] : l).length; i;
		b = getOffset(l[--i]), (a.l == b.l || (a.l > b.l ? a.l <= b.r : b.l <= a.r))
		&& (a.t == b.t || (a.t > b.t ? a.t <= b.b : b.t <= a.b)) && (r[r.length] = l[i]));
	return j ? !!r.length : r;
};


function getControl(controlName) {
    return document.getElementById(controlName);
}

function setPosition(controlToSet, positionedControl) {
    setPositionOffset(controlToSet, positionedControl, 0, 0);
}

function setPositionOffset(controlToSet, positionedControl, offsetX, offsetY) {
    if (!positionedControl) {
        controlToSet.style.display = "none";
        return;
    }

    var curLeft = curTop = 0;

    if (positionedControl.offsetParent) {
        curLeft = positionedControl.offsetLeft;
        curTop = positionedControl.offsetTop;

        while (positionedControl = positionedControl.offsetParent) {
            curLeft += positionedControl.offsetLeft;
            curTop += positionedControl.offsetTop;
        }
    }

    controlToSet.style.left = curLeft + offsetX;
    controlToSet.style.top = curTop + offsetY;
}
