﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.Collections.Specialized;

namespace DebugModule
{
    public class DebugPaneControl : WebControl
    {
        private const string showDebug = "showDebug(this, '{0}');";
        private const string hideDebug = "javascript:hideDebugByName('{0}');";
        private const string setSpotPosition = "setPosition(getControl('{0}'), getControl('{1}'));";
        private const string BagOutputFormat = "{0}: {1}";

        public DebugPaneControl()
        {
            this.EnableViewState = false;
            this.CssClassDebugSpot = "debugSpot";
            this.CssClassDebugPane = "debugPane";
            this.CssClassButtons = "debugPaneButtons";
        }

        public string CssClassDebugSpot { get; set; }
        public string CssClassDebugPane { get; set; }
        public string CssClassButtons { get; set; }
        public UserControl ControlToDebug { get; set; }

        protected override void Render(HtmlTextWriter writer)
        {
            if (this.ControlToDebug != null && this.ControlToDebug.Controls.Count != 0)
            {
                Control zerothControl = this.ControlToDebug.Controls[0];
                DebugControlItem controlDebugBag = DebugControlInjection.GetDebugControlItem(this.ControlToDebug);
                
                if (controlDebugBag != null && zerothControl != null)
                {
                    RenderDebugSpot(writer, zerothControl);
                    RenderDebugPane(writer, controlDebugBag);
                }
            }
        }

        protected void WriteSimpleTag(HtmlTextWriter writer, HtmlTextWriterTag tag, string format, params object[] args)
        {
            writer.RenderBeginTag(tag);
            writer.Write(format, args);
            writer.RenderEndTag();
            writer.WriteLine();
        }

        #region Private Methods

        private void RenderDebugSpot(HtmlTextWriter writer, Control zerothControl)
        {
            string debugSpotClientId = this.ClientID + "debugSpot";

            writer.AddAttribute(HtmlTextWriterAttribute.Class, this.CssClassDebugSpot);
            writer.AddAttribute(HtmlTextWriterAttribute.Id, debugSpotClientId);
            writer.AddAttribute(HtmlTextWriterAttribute.Onclick, string.Format(showDebug, this.ClientID));
            WriteSimpleTag(writer, HtmlTextWriterTag.Div, "&nbsp;");

            string id = DebugControlInjection.GetClientID(zerothControl);
            WriteSimpleTag(writer, HtmlTextWriterTag.Script, setSpotPosition, debugSpotClientId, id);
        }

        private void RenderDebugPane(HtmlTextWriter writer, DebugControlItem debugItem)
        {
            writer.AddAttribute(HtmlTextWriterAttribute.Class, this.CssClassDebugPane);
            writer.AddAttribute("debugPane", "true");
            writer.AddAttribute(HtmlTextWriterAttribute.Id, this.ClientID);
            writer.RenderBeginTag(HtmlTextWriterTag.Div);

            foreach (var pair in debugItem.Properties)
            {
                WriteSimpleTag(writer, HtmlTextWriterTag.Div, BagOutputFormat, pair.Key, pair.Value);
            }

            writer.AddAttribute(HtmlTextWriterAttribute.Class, this.CssClassButtons);
            writer.RenderBeginTag(HtmlTextWriterTag.Div);

            writer.AddAttribute(HtmlTextWriterAttribute.Href, string.Format(hideDebug, this.ClientID));
            WriteSimpleTag(writer, HtmlTextWriterTag.A, "Hide");

            writer.RenderEndTag(); //buttons Div tag
            writer.WriteLine();

            writer.RenderEndTag(); //outer div tag
            writer.WriteLine();
        }

        #endregion
    }
}
