﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace DebugModule
{
    public static class DebugPageInjection
    {
        private const string PageStopWatchItemKey = "Debug_PageStopwatch";
        private const string ContentTypeHtml = "text/html";
        private const string ResponseStringPrerenderTime = "<div class='{1}'>Prerender Request Time: {0}ms</div>";
        private const string ResponseStringTotalTime = "<div class='{1}'>Total Request Time: {0}ms</div>";

        public static void InitialisePageDebug()
        {
            Stopwatch stopwatch = new Stopwatch();
            HttpContext.Current.Items[PageStopWatchItemKey] = stopwatch;
            stopwatch.Start();
        }

        public static void CompletePageDebug()
        {
            if (HttpContext.Current.Response.ContentType == ContentTypeHtml && HttpContext.Current.Response.StatusCode == 200)
            {
                //only output when the response is a successful html page

                Stopwatch stopwatch = HttpContext.Current.Items[PageStopWatchItemKey] as Stopwatch;
                if (stopwatch != null)
                {
                    stopwatch.Stop();

                    WriteToResponse(HtmlComment.HtmlCommentFormat, "Start Debug Injection - Page Total Time");
                    WriteToResponse(ResponseStringTotalTime, stopwatch.ElapsedMilliseconds, "pageDebugPane");
                    WriteToResponse(HtmlComment.HtmlCommentFormat, "End Debug Injection - Page Total Time");
                }
            }
        }

        public static void InjectPageDebug(Page page)
        {
            if (page != null && HttpContext.Current.Response.ContentType == ContentTypeHtml)
            {
                page.PreRenderComplete += new EventHandler(Page_PreRenderComplete);
                InjectControlDebug(page);
            }
        }

        #region Private Methods

        private static void InjectControlDebug(Page page)
        {
            page.LoadComplete += new EventHandler(Page_LoadComplete);
        }

        private static void Page_LoadComplete(object sender, EventArgs e)
        {
            Page page = HttpContext.Current.Handler as Page;
            if (page.Controls.Count != 0)
            {
                DebugControlInjection.AddControlDebug(page);
            }
        }

        private static void Page_PreRenderComplete(object sender, EventArgs e)
        {
            Stopwatch stopwatch = HttpContext.Current.Items[PageStopWatchItemKey] as Stopwatch;
            if (stopwatch != null)
            {
                WriteToResponse(HtmlComment.HtmlCommentFormat, "Start Debug Injection - Page Prerender Time");
                WriteToResponse(ResponseStringPrerenderTime, stopwatch.ElapsedMilliseconds, "pageDebugPane");
                WriteToResponse(HtmlComment.HtmlCommentFormat, "End Debug Injection - Page Prerender Time");
            }

            //add the stylesheet and javascript
            Page page = HttpContext.Current.Handler as Page;
            HtmlLink debugCss = new HtmlLink();
            debugCss.Href = "/Debug.css"; //ideally this would be config driven
            debugCss.Attributes.Add("rel", "Stylesheet");
            debugCss.Attributes.Add("type", "text/css");
            page.Header.Controls.Add(debugCss);
            page.ClientScript.RegisterClientScriptInclude("DebugScript", "/Debug.js");  //ideally this would be config driven
        }

        private static void WriteToResponse(string format, params object[] args)
        {
            HttpContext.Current.Response.Write(string.Format(format, args));
        }

        #endregion
    }
}
