﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Diagnostics;
using System.Web.UI;

namespace DebugModule
{
    public class DebugHttpModule : IHttpModule
    {
        #region IHttpModule Members

        public void Init(HttpApplication context)
        {
            if (HttpContext.Current.IsDebuggingEnabled)
            {
                //only add debug, if <compilation debug="true">
                context.BeginRequest += new EventHandler(context_BeginRequest);
                context.PostMapRequestHandler += new EventHandler(context_PostMapRequestHandler);
                context.EndRequest += new EventHandler(context_EndRequest);
            }
        }

        public void Dispose()
        {
        }

        #endregion

        private void context_BeginRequest(object sender, EventArgs e)
        {
            DebugPageInjection.InitialisePageDebug();
        }

        private void context_EndRequest(object sender, EventArgs e)
        {
            DebugPageInjection.CompletePageDebug();
        }

        private void context_PostMapRequestHandler(object sender, EventArgs e)
        {
            DebugPageInjection.InjectPageDebug(HttpContext.Current.Handler as Page);
        }
    }
}
