﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using facebook.Web;
using facebook;

namespace SimpleQuery
{
	public partial class _Default : System.Web.UI.Page
	{
		protected void Page_Load(object sender, EventArgs e)
		{
			if (FacebookContext.Current.TryAuthenticating(true))
			{
				var db = new FacebookDataContext();
				Example1();
				Example2();
				Example3();
				Example4();
				DataBind();
			}
		}


		/// <summary>
		/// Query vs. Method Syntax
		/// </summary>
		void Example1()
		{
			var db = new FacebookDataContext();
			//LINQ Query Syntax
			var myUser = from user in db.user where user.uid == db.uid select user;
			//LINQ Method Syntax (the same query)
			var myUser2 = db.user.Where(t => t.uid == db.uid);

			Example1DataList.DataSource = myUser.Take(10);
		}

		/// <summary>
		/// Nested Queries
		/// </summary>
		void Example2()
		{
			var db = new FacebookDataContext();
			var friendIDs = from friend in db.friend_info where friend.uid1 == db.uid select friend.uid2;
			var friendDetails = from user in db.user where friendIDs.Contains(user.uid) select user;
			//Or in a single line
			var friendDetails2 = from user in db.user where (from friend in db.friend_info where friend.uid1 == db.uid select friend.uid2).Contains(user.uid) select user;

			Example2DataList.DataSource = friendDetails2.Take(10);
		}

		/// <summary>
		/// Anonymous Objects
		/// </summary>
		void Example3()
		{
			var db = new FacebookDataContext();
			var friendIDs = from friend in db.friend_info where friend.uid1 == db.uid select friend.uid2;
			var friendDetails = from user in db.user where friendIDs.Contains(user.uid) select new { Name = user.name, Picture = user.pic_small };

			Example3DataList.DataSource = friendDetails.Skip(10).Take(10);
		}

		/// <summary>
		/// Paging and Sorting
		/// </summary>
		void Example4()
		{
			var db = new FacebookDataContext();
			var friendIDs = from friend in db.friend_info where friend.uid1 == db.uid select friend.uid2;
			var friendDetails = (from user in db.user where friendIDs.Contains(user.uid) orderby user.name select new { Name = user.name, Picture = user.pic_small }).Skip(4).Take(5);

			Example4DataList.DataSource = friendDetails;
		}
	}
}
