﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Reflection;
namespace CustomComponents
{
    /// <summary>
    /// Summary description for SqlDataSourceEx
    /// </summary>
    public class SqlDataSourceEx : System.Web.UI.WebControls.SqlDataSource
    {
        public SqlDataSourceEx()
        {
        }
        /// <summary>
        /// Attach a handler to Selecting event
        /// </summary>
        /// <param name="e"></param>
        protected override void OnInit(EventArgs e)
        {
            base.Selecting += new System.Web.UI.WebControls.SqlDataSourceSelectingEventHandler(SqlDS_Selecting);
            base.OnInit(e);
        }
        /// <summary>
        /// Finds DBSpecialParameters in SqlDataSourceEx, find parameter in the Parameters collection
        /// of the command object wiht the same name, than using reflection find 
        /// DBParamTypePropertyName property in the parameter and assign DBParamTypeEnumeValue to it.
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="selectingArgs"></param>
        protected void SqlDS_Selecting(object sender, System.Web.UI.WebControls.SqlDataSourceSelectingEventArgs selectingArgs)
        {
            foreach (System.Web.UI.WebControls.Parameter selPar in base.SelectParameters)
            {
                if (selPar is DBSpecialParameter)
                {
                    foreach (System.Data.Common.DbParameter commParam in selectingArgs.Command.Parameters)
                    {
                        if (selPar.Name == commParam.ParameterName)
                        {
                            try
                            {
                                // Cast to DBSpecialParameter
                                DBSpecialParameter dbp = selPar as DBSpecialParameter;
                                if (dbp == null)
                                    throw new ApplicationException(String.Format("DBSpecialParameter error: {0} is not DBSpecialParameter!", selPar.Name));
                                // Get parameter type object
                                Type t = commParam.GetType();
                                // Get the dbType property
                                PropertyInfo dbTypeProperty = t.GetProperty(dbp.DBParamTypePropertyName);
                                if (dbTypeProperty == null)
                                    throw new ApplicationException(String.Format("DBSpecialParameter error: No property with '{0}' name exists in '{1}'!",
                                        dbp.DBParamTypePropertyName, t.FullName));
                                // Get type of the property 
                                Type enumType = dbTypeProperty.PropertyType;
                                // Get the cursor type enum value
                                FieldInfo evalue = enumType.GetField(dbp.DBParamTypeEnumeValue);
                                if (evalue == null)
                                    throw new ApplicationException(String.Format("DBSpecialParameter error: No enum value '{0}' exists in '{1}'!",
                                        dbp.DBParamTypeEnumeValue, enumType.FullName));
                                // Set the dbType property to enum cursor value
                                dbTypeProperty.SetValue(commParam, evalue.GetValue(enumType), null);
                            }
                            catch
                            {
                                throw;
                            }
                            break;
                        }
                    }
                }
            }
        }
    }
}