using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using Tirex;


public partial class WebControls_PhotoAlbumControl : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PopulateThumbnails();
            imgPhoto.Attributes.Add("src", GetImageUrl(0));
        }
    }

    private string GetImageUrl(int step)
    {
        DataSet ds = new DataSet();
        int imageCount = Int32.Parse(Session["ImageCount"].ToString());
        int imageIndex = 0;
        int imageId = 0;

        //Get image index from Session
        try
        {
            imageIndex = Int32.Parse(Session["ImageIndex"].ToString());
            if (imageIndex > imageCount)
            {
                imageIndex = 0;
            }
        }
        catch
        {
            imageIndex = 0;
        }

        try
        {
            ds = (DataSet) Session["Images"];
        }
        catch { }

        //Get current image Id
        try
        {
            imageId = Int32.Parse(ds.Tables[0].Rows[imageIndex]["ImageId"].ToString());
        }
        catch { }

        if (step == 0)
        {
            imageIndex = imageIndex;
        }
        else if (step == 1)
        {
            imageIndex = imageIndex + 1;
        }
        else if (step == -1)
        {
            imageIndex = imageIndex - 1;
        }

        //Get new image Id
        try
        {
            imageId = Int32.Parse(ds.Tables[0].Rows[imageIndex]["ImageId"].ToString());
            Session["ImageIndex"] = imageIndex.ToString();
        }
        catch { }

        string url = "ImagePage.aspx?s=l&id=" + imageId.ToString();
        return url;
    }


    protected void lbForward_Click(object sender, EventArgs e)
    {
        imgPhoto.Attributes.Add("src", GetImageUrl(1));
    }

    protected void lbBack_Click(object sender, EventArgs e)
    {
        imgPhoto.Attributes.Add("src", GetImageUrl(-1));
    }

    protected void ThumbnailsItemDatabound(object sender, DataListItemEventArgs e)
    {
        Image tImage = (Image)dlThumbnails.Controls[e.Item.ItemIndex].Controls[3];

        string ajaxServerUrl = "GetSelectedImage.aspx";
        tImage.Attributes.Add("src", "ImagePage.aspx?s=s&id=" + ((DataRowView)e.Item.DataItem).Row.ItemArray[0].ToString());
        tImage.Attributes.Add("onclick", "getImage('" + ajaxServerUrl + "'," + ((DataRowView)e.Item.DataItem).Row.ItemArray[0].ToString() + ")");
        tImage.Attributes.Add("onmouseover", "getImage('" + ajaxServerUrl + "'," + ((DataRowView)e.Item.DataItem).Row.ItemArray[0].ToString() + ")");
    }

    public void PopulateThumbnails()
    {
        DataSet ds = new DataSet();
        ImageClass.GetImages(ds);
        dlThumbnails.DataSource = ds;
        dlThumbnails.DataBind();

        Session["ImageCount"] = ds.Tables[0].Rows.Count;
        Session["Images"] = ds;
    }
}
