﻿// JavaScript File
//
//	Desciption	:	This javascript file is created to segregate the AJAX code
//					from the C# code behind server source code.
//				
//	Author		:	Katerina Kostrioukova
//	Revisions	:


// CONSTANTS	
var COMPLETE		        = 4;
var OK  			        = 200;	

var SlideShowInterval;
var TimeInterval = 1;
var SlideShowFlag = true;

var imageClient = null;
var slideClient = null;

//branch for Firefox version
if (window.XMLHttpRequest)
{
	imageClient = new XMLHttpRequest();
	slideClient = new XMLHttpRequest();
} 

//branch for IE/Windows ActiveX version
else if (window.ActiveXObject)
{
	imageClient = new ActiveXObject("Microsoft.XMLHTTP");
	slideClient = new ActiveXObject("Microsoft.XMLHTTP");
}


//===============================================================
//AJAX IMAGE
//Sending information to server
function getImage(AjaxServerUrl, id)
{  
    
    var url = AjaxServerUrl + "?id=" + id
	imageClient.open("GET", url);
	imageClient.onreadystatechange = getImageBack;			
	imageClient.send(null);				
}

//Waiting and processing server response
function getImageBack(response)
{	
    var imageId = 0;
    
	try
	{    
		if(imageClient.readyState == COMPLETE && imageClient.status == OK)
		{	    		    
	    	//branch for Firefox version
			if (document.implementation.createDocument)//Firefox
			{			  			
                //Get Image
				var xmlElementImageId = imageClient.responseXML.getElementsByTagName("Root")[0].childNodes[0];
                imageId = xmlElementImageId.textContent;
            }
			//branch for IE/Windows ActiveX version
			else if (document.all)//IE
			{						
			    xmlDocument = new ActiveXObject('Microsoft.XMLDOM');
			    xmlDocument.async = false;
			    	    
                //The responseText is loaded into XML document
			    xmlDocument.loadXML(imageClient.responseText);

                //Get Image
				var xmlElementImageId = xmlDocument.selectSingleNode('Root/ImageId');
                imageId = xmlElementImageId.text;
			    
            }        	
            
            var imgPhoto;
			imgPhoto = window.document.getElementById("PhotoAlbumControl1_imgPhoto");
			imgPhoto.src = "ImagePage.aspx?s=l&id=" + imageId;
	    }
	}
	catch(err)
	{
		alert(err.message);
	}			      
}

	
//Sending information to server
function getSlideShow(AjaxServerUrl)
{  
    if (SlideShowInterval != null)
    {
        try
        {
	        clearInterval(SlideShowInterval);
	    }
	    catch (ex)
	    {
	    }
	}
	
	AjaxSlideShowUrl = AjaxServerUrl;
	
    SlideShowInterval =	setInterval('SlideShowRecursion()', TimeInterval * 1000);  	
    //SlideShowInterval =	setInterval('SlideShowRecursion()', 5 * 1000);  	
}


//Sending information to server
function SlideShowRecursion()
{
	try
	{   
		//callBack;				
		if (!SlideShowFlag)
			return;
		
		var currentDate = new Date();    
        var url = AjaxSlideShowUrl + "?date=" + currentDate;
	    slideClient.open("GET", url);
	    slideClient.onreadystatechange = getSlideShowBack;
        SlideShowFlag = false;	    
        slideClient.send(null);	
        
	}
	catch(ex)
	{
		alert(ex.message);
	}
}


//Waiting and processing server response
function getSlideShowBack(response)
{	
    var imageId = 0;
    
	try
	{    
		if(slideClient.readyState == COMPLETE && slideClient.status == OK)
		{	
		
            SlideShowFlag = true;
            	    	
            //branch for Firefox version
			if (document.implementation.createDocument)//Firefox
			{			  
                //Get Image
				var xmlElementImageId = slideClient.responseXML.getElementsByTagName("Root")[0].childNodes[0];
                imageId = xmlElementImageId.textContent;
            }
			//branch for IE/Windows ActiveX version
			else if (document.all)//IE
			{						               
			    xmlDocument = new ActiveXObject('Microsoft.XMLDOM');
			    xmlDocument.async = false;
			    	    
                //The responseText is loaded into XML document
			    xmlDocument.loadXML(slideClient.responseText);

                //Get Image
				var xmlElementImageId = xmlDocument.selectSingleNode('Root/ImageId');
                imageId = xmlElementImageId.text;
            }  
                  	
            var imgPhoto;
		    imgPhoto = window.document.getElementById("PhotoAlbumControl1_imgPhoto");
		    imgPhoto.src = "ImagePage.aspx?s=l&id=" + imageId;
	    }
	}
	catch(err)
	{
		alert(err.message);
	}			      
}

function setTimeInterval(ddl)
{
    //slideClient = null;
    if (SlideShowInterval != null)
        clearInterval(SlideShowInterval);

    TimeInterval = ddl.options[ddl.selectedIndex].value;    
}