using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using System.Drawing;
using System.IO;

namespace Tirex
{
    /// <summary>
    /// Summary description for QuoteClass
    /// </summary>
    public class ImageClass
    {
        public static void GetImages(DataSet ds)
        {
            string sqlString = "SELECT ImageId FROM Images";
            SqlHelper.FillDataset(SqlHelper.connection(), CommandType.Text, sqlString, ds, new string[] { "Products" });
        }

        public static void AddImage(byte[] imageSmall, byte[] imageLarge)
        {
            string sqlText = @"INSERT INTO Images
                                (ImageSmall, ImageLarge)
                                VALUES
                                (@ImageSmall, @ImageLarge)";

            SqlParameter[] sqlParameters = new SqlParameter[2];
            
            //	Build/add image parameter
            sqlParameters[0] = new SqlParameter("@ImageSmall", SqlDbType.Image);
            sqlParameters[0].Value = imageSmall;
            sqlParameters[0].Direction = ParameterDirection.Input;

            //	Build/add image parameter
            sqlParameters[1] = new SqlParameter("@ImageLarge", SqlDbType.Image);
            sqlParameters[1].Value = imageLarge;
            sqlParameters[1].Direction = ParameterDirection.Input;


            SqlHelper.ExecuteNonQuery(SqlHelper.connection(), CommandType.Text, sqlText, sqlParameters);
        }

        public static byte[] ResizeImage(int newWidth, byte[] pictureBytes)
        {

            Bitmap b = (Bitmap)Bitmap.FromStream(new MemoryStream(pictureBytes));
            int imageWidth = b.Width;
            int imageHeight = b.Height;


            double newHeightD = Convert.ToDouble(newWidth) / Convert.ToDouble(imageWidth) * Convert.ToDouble(imageHeight);
            int newHeight = Convert.ToInt32(newHeightD);

            Bitmap output = new Bitmap(b, new Size(newWidth, newHeight));
            MemoryStream ms = new MemoryStream();
            output.Save(ms, System.Drawing.Imaging.ImageFormat.Jpeg);

            byte[] bmpBytes = ms.GetBuffer();
            output.Dispose();
            ms.Close();

            return bmpBytes;

        }

        public static int GetImageId(int id)
        {
            int newId = 0;

            if (id == 0)
            {
                string sqlString = @"SELECT TOP 1 ImageId FROM Images
                                    ORDER BY ImageId";
                DataSet ds = new DataSet();
                SqlHelper.FillDataset(SqlHelper.connection(), CommandType.Text, sqlString, ds, new string[] { "Products" }, null);
                newId = Int32.Parse(ds.Tables[0].Rows[0][0].ToString());

            }
            else
            {
                DataSet ds = new DataSet();
                SqlParameter[] paramList = new SqlParameter[] 
				{
					new SqlParameter("@ImageId", id)
				};
                
                string sqlString = @"SELECT TOP 1 ImageId FROM Images
                                    WHERE ImageId > @ImageId
                                    ORDER BY ImageId";

                SqlHelper.FillDataset(SqlHelper.connection(), CommandType.Text, sqlString, ds, new string[] { "Products" }, paramList);

                try
                {
                    newId = Int32.Parse(ds.Tables[0].Rows[0][0].ToString());
                }
                catch
                {
                    sqlString = @"SELECT TOP 1 ImageId FROM Images
                                    ORDER BY ImageId";

                    SqlHelper.FillDataset(SqlHelper.connection(), CommandType.Text, sqlString, ds, new string[] { "Products" }, null);
                    newId = Int32.Parse(ds.Tables[0].Rows[0][0].ToString());
                }
            }

            return newId;
        }

    }
}