﻿using System;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Activation;
using System.ServiceModel.Web;
using System.Collections.Generic;

namespace WCF_AJAX.Services
{
    [ServiceContract(Namespace = "")]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class ApplicationService
    {
        // Add [WebGet] attribute to use HTTP GET
        [OperationContract]
        public List<Data.CustomerItem>searchCustomers(string searchText)
        {
            var listOfCustomerItems = new List<Data.CustomerItem>();
            var dataContext = new Data.NorthwindDataContext();
            foreach (var result in dataContext.SearchCustomers(searchText))
            {
                var item = new Data.CustomerItem();
                item.CustomerID = result.CustomerID;
                item.ContactName = result.ContactName;
                listOfCustomerItems.Add(item);
            }
            return listOfCustomerItems;
        }

        // Add more operations here and mark them with [OperationContract]
    }
}
