﻿<%@ Page Language="C#" MasterPageFile="~/MasterPage.master" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="cc1" %>

<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder1" Runat="Server">
    <ajax:UpdatePanel ID="UpdatePanel1" runat="server" UpdateMode="Conditional">
        <ContentTemplate>
            <asp:GridView ID="GridView1" runat="server" AutoGenerateColumns="False" 
                DataKeyNames="CategoryID" DataSourceID="SqlDataSource1">
                <Columns>
                    <asp:BoundField DataField="CategoryID" HeaderText="CategoryID" 
                        InsertVisible="False" ReadOnly="True" SortExpression="CategoryID" />
                    <asp:BoundField DataField="CategoryName" HeaderText="CategoryName" 
                        SortExpression="CategoryName" />
                    <asp:BoundField DataField="Description" HeaderText="Description" 
                        SortExpression="Description" />
                </Columns>
            </asp:GridView>    
        </ContentTemplate>        
        <Triggers>
            <ajax:AsyncPostBackTrigger ControlID="OkButton" EventName="Click" />
        </Triggers>
    </ajax:UpdatePanel>
    <asp:SqlDataSource ID="SqlDataSource1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:NorthwindConnectionString %>" 
        SelectCommand="SELECT [CategoryID], [CategoryName], [Description] FROM [Categories]">
    </asp:SqlDataSource>
    <asp:LinkButton ID="LinkButton1" runat="server">Click here to add new data row.</asp:LinkButton>    
    <cc1:ModalPopupExtender ID="ModalPopupExtender1" runat="server"
                            TargetControlID="LinkButton1"
                            PopupControlID="Panel1"
                            OkControlID="OkButton"
                            OnOkScript="onOkClick()"
                            CancelControlID="CancelButton"
                            BackgroundCssClass="modalBackground"
                            DropShadow="true">
    </cc1:ModalPopupExtender>    
    <asp:Panel ID="Panel1" runat="server" CssClass="modalPopup">
        <div>
            <h3>
                Add new category</h3>
        </div>        
        <div>
            <table border="0" cellpadding="4" cellspacing="4" width="80%">
                <tr>
                    <td nowrap="nowrap" width="10%">
                        Category name:</td>
                    <td>
                        <input type="text" id="TextBox1" maxlength="10" />
                    </td>
                </tr>
                <tr>
                    <td>
                        Description:</td>
                    <td>
                        <input type="text" id="TextBox2" maxlength="50" />
                    </td>
                </tr>
                <tr>
                    <td>&nbsp;</td>
                    <td>
                        <asp:Button ID="OkButton" runat="server" Text="Ok" onclick="OkButton_Click" />
                        &nbsp;<input type="button" id="CancelButton" value="Άκυρο" />                        
                    </td>
                </tr>
            </table>
        </div>                        
    </asp:Panel>                          
    <script type="text/javascript">
        function onOkClick() {
            var cat_name = $get("TextBox1").value;
            var description = $get("TextBox2").value;
            DB.AddCategory(cat_name, description, onAddSuccess, onAddFailure);
        }
        
        function onAddSuccess(result, context, methodName) {            
            var OkButton = document.getElementById('<%= OkButton.ClientID %>');
            __doPostBack(OkButton.name, "");
        }
        
        function onAddFailure(error, context, methodName) {
            alert(error.get_message());
        }
    </script>    
</asp:Content>

