using System;
using System.Collections.Specialized;
using System.Text;
using System.Web.Configuration;
using System.Web.UI;
using SmartSoft.QueryStringEncryption;

public partial class _Default : Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PrepareSendButton();
        }

        StringBuilder transmittedQueryStrings = new StringBuilder();

        // Parse query strings if there are any
        foreach (string key in Request.QueryString.AllKeys)
        {
            if (transmittedQueryStrings.Length > 0) transmittedQueryStrings.Append("&amp;");
            transmittedQueryStrings.Append(string.Format("{0}={1}", key, Request.QueryString[key]));
        }

        // Output query string
        if (transmittedQueryStrings.Length > 0)
        {
            lblParam.Text = transmittedQueryStrings.ToString();
            divReceivedParam.Visible = true;
        }
    }

    private void PrepareSendButton()
    {
        NameValueCollection queryStrings = new NameValueCollection();
        queryStrings.Add("param1", "Test1");
        queryStrings.Add("param2", "Test2");
        queryStrings.Add("param3", "Test3");

        // Encrypt query strings
        string encryptedString = CryptoQueryStringHandler.EncryptQueryStrings(queryStrings,
                                        WebConfigurationManager.AppSettings["CryptoKey"]);

        btnSendParams.PostBackUrl = string.Concat("~/Default.aspx?", encryptedString);
    }
}