﻿<?xml version='1.0' encoding='UTF-8'?>
<!--Style RSS so that it is readable. -->

<xsl:stylesheet
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:dc="http://purl.org/dc/elements/1.1/"
	version="1.0"
>

  <xsl:template match='/rss'>
    <html>
      <head>
        <title>
          RSS Feed for <xsl:value-of select='channel/title'/>
        </title>

        <link rel="stylesheet" href="App_Themes/Database/Stylesheet.css" />


      </head>
      <body>
        <table style="width:100%;height:100%">
          <tr style="height:100%">
            <td valign="top" STYLE="padding:10px">
              <xsl:value-of select="' '" />
            </td>
            <td>
              <a href="default.aspx">
                <IMG ID="Image1" border="0" src="Voyagers Logo2.GIF" />
                <br />
              </a>

              <br/>
              <br/>
              <H1>
                RSS Feed for <xsl:value-of select='channel/title'/>
              </H1>

              <div>
                <p>By subscribing to this Really Simple Syndication (RSS) feed from Voyagers' Canoe Club, you can have information on new events, resources, articles and galleries delivered in an RSS reader or aggregator. RSS is convenient, because you can subscribe to feeds from several sources and automatically aggregate headlines from all the sources into one list. You can quickly browse the list of new content without visiting each site to search for new info of interest.</p>
                <p>
                  For more information on subscribing to this feed and finding an aggregator, see <a href="http://www.sekos.com/rss/aboutrss.htm">About Really Simple Syndication</a>.
                </p>
                <hr />
                <ul>
                  <xsl:apply-templates select='channel/item' />
                </ul>
              </div>
            </td>
          </tr>
        </table>
      </body>
    </html>
  </xsl:template>

  <xsl:template match='item'>
    <li STYLE="padding-left:1em">
      <a href='{link}'>
        <xsl:value-of select='title'/>
      </a>
      <br/>
      <xsl:value-of select='description' disable-output-escaping='yes' />
      <br />
      <xsl:if test="dc:creator">
        <strong>Author: </strong>
        <xsl:value-of select='dc:creator' />
        <br />
      </xsl:if>
      <xsl:if test="pubDate">
        <strong>Date: </strong>
        <xsl:value-of select='pubDate' />
        <br />
      </xsl:if>
      <font color='gray'>
        <xsl:for-each select='category'>
          <xsl:value-of select='.' /> |
        </xsl:for-each>
      </font>
      <br/>
    </li>
  </xsl:template>

  <xsl:template match='category'>
    <xsl:value-of select='.'/> |
  </xsl:template>


</xsl:stylesheet>